/*******************************************************************************
* netoutput.h: network output
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: netoutput.h,v 1.1 2001/11/22 01:51:12 bozo Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _NETOUTPUT_H_
#define _NETOUTPUT_H_


#define TS_IN_ETHER 7                // TS packets that fit in an ethernet


//------------------------------------------------------------------------------
// C_NetOutput: output streaming over networks
//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
class C_NetOutput : public C_Output
{
 public:
  C_NetOutput(const C_String& strInterface,
              const C_String& strSrcHost, const C_String& strSrcPort,
              const C_String& strDstHost, const C_String& strDstPort);
  virtual ~C_NetOutput();

  virtual void OnInit();
  virtual void OnClose();

 protected:
  virtual void WriteToPort();

  C_Socket m_cSocket;
  C_SocketBuff m_cSocketBuff;

  // Output parameters
  C_String m_strInterface;
  C_String m_strSrcHost;
  C_String m_strSrcPort;
  C_String m_strDstHost;
  C_String m_strDstPort;
  C_InetAddr m_cOutputInetAddr;
#ifdef BUGGY_VLC
  byte m_ByteBuff[TS_PACKET_LEN * TS_IN_ETHER];
#endif
};


#else
#error "Multiple inclusions of netoutput.h"
#endif

