#! /usr/bin/perl

#Annoyance Filter Frontend
#
#Specifically designed to be used with the Maildir format, with the
#Maildir located in each users home directory
#
#To Install:
#1)Create a list of users that want to have their mail filtered in 
#  /etc/filterusers.  Just a straight forward list.
#2)Create user's dictionary in /home/dict.bin
#  You can obviously change that if you want, but on my server nobody has
#  shell access so it doesn't have to be pretty
#3)Schedule in cron as needed
#
#
#The way this script works is to compare the current system time with the
#last modified time of each file in your Maildir/cur/ directory.  If the
#age is under the specified length (default: 1 hour), it runs annoyance-filter
#against the mail file.  If annoyance-filter returns a 3 (SPAM), the file
#gets deleted.

# Contributed by Travis Groth, licensed under the GNU General Public License--
# see ../COPYING.GNU for details.

#specify path to annoyance-filter
$annoypath = "/home/media";

#specify how new a message has to be to be considered "new"
$age = 1200;

open USERS, "/etc/filterusers" or die "Can't open /etc/filterusers\n";
@users = <USERS>;
close USERS;

$currenttime = time;
#print "Current Time: $currenttime\n";



foreach $user(@users){
    chomp $user;
    opendir DIR, "/home/$user/Maildir/cur/" or die "Can't open $user's Maildir\n";
    @files = readdir(DIR);
    closedir DIR;
    
    foreach $file(@files){
	if($file eq "."){
	    next;
	}
	$file = "/home/$user/Maildir/cur/$file";
	$creationtime = (stat($file))[9];  
	#print "$creationtime\n";
	if($currenttime - $creationtime <= $age){
	    #print "$creationtime:$file\n";
	    system("$annoypath/annoyance-filter --read /home/$user/dict.bin --classify $file > /dev/null");
	    $exitval = $? >> 8;
	    #print ("Exit Value is: $exitval\n\n");
	    if($exitval == 3){
		unlink "$file";
	    }
	}
    }
	opendir DIR, "/home/$user/Maildir/new/" or die "Can't open $user's Maildir\n";
	@files = readdir(DIR);
	closedir DIR;
        
	foreach $file(@files){
	    if($file eq "."){
		next;
	    }
	
	    $file = "/home/$user/Maildir/new/$file";
	
	    system("$annoypath/annoyance-filter --read /home/$user/dict.bin --classify $file > /dev/null");
	
	    $exitval = $? >> 8;
	    #print ("Exit Value is: $exitval\n\n");
	
	    if($exitval == 3){
		unlink "$file";
	    }
	}
	
}    

exit;


