/* baobab-application.c generated by valac 0.32.0.59-edc5, the Vala compiler
 * generated from baobab-application.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include "config.h"


#define BAOBAB_TYPE_APPLICATION (baobab_application_get_type ())
#define BAOBAB_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplication))
#define BAOBAB_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))
#define BAOBAB_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))

typedef struct _BaobabApplication BaobabApplication;
typedef struct _BaobabApplicationClass BaobabApplicationClass;
typedef struct _BaobabApplicationPrivate BaobabApplicationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BAOBAB_TYPE_WINDOW (baobab_window_get_type ())
#define BAOBAB_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_WINDOW, BaobabWindow))
#define BAOBAB_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_WINDOW, BaobabWindowClass))
#define BAOBAB_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_WINDOW))
#define BAOBAB_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_WINDOW))
#define BAOBAB_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_WINDOW, BaobabWindowClass))

typedef struct _BaobabWindow BaobabWindow;
typedef struct _BaobabWindowClass BaobabWindowClass;

#define BAOBAB_TYPE_SCAN_FLAGS (baobab_scan_flags_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BaobabApplication {
	GtkApplication parent_instance;
	BaobabApplicationPrivate * priv;
};

struct _BaobabApplicationClass {
	GtkApplicationClass parent_class;
};

struct _BaobabApplicationPrivate {
	GSettings* _prefs_settings;
	GSettings* _ui_settings;
};

typedef enum  {
	BAOBAB_SCAN_FLAGS_NONE = 1 << 0,
	BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS = 1 << 1
} BaobabScanFlags;


static gpointer baobab_application_parent_class = NULL;

GType baobab_application_get_type (void) G_GNUC_CONST;
#define BAOBAB_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_APPLICATION, BaobabApplicationPrivate))
enum  {
	BAOBAB_APPLICATION_DUMMY_PROPERTY,
	BAOBAB_APPLICATION_PREFS_SETTINGS,
	BAOBAB_APPLICATION_UI_SETTINGS
};
static void baobab_application_on_quit_activate (BaobabApplication* self);
static void _baobab_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_application_real_activate (GApplication* base);
BaobabWindow* baobab_window_new (BaobabApplication* app);
BaobabWindow* baobab_window_construct (GType object_type, BaobabApplication* app);
GType baobab_window_get_type (void) G_GNUC_CONST;
static void baobab_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
GType baobab_scan_flags_get_type (void) G_GNUC_CONST;
void baobab_window_scan_directory (BaobabWindow* self, GFile* directory, BaobabScanFlags flags);
BaobabApplication* baobab_application_get_default (void);
GHashTable* baobab_application_get_excluded_locations (BaobabApplication* self);
static guint _g_file_hash_ghash_func (gconstpointer key);
static gboolean _g_file_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _g_object_unref0_ (gpointer var);
GSettings* baobab_application_get_prefs_settings (BaobabApplication* self);
static gchar* _variant_get1 (GVariant* value);
static void baobab_application_real_startup (GApplication* base);
static void baobab_application_set_ui_settings (BaobabApplication* self, GSettings* value);
static void baobab_application_set_prefs_settings (BaobabApplication* self, GSettings* value);
GSettings* baobab_application_get_ui_settings (BaobabApplication* self);
static gint baobab_application_real_handle_local_options (GApplication* base, GVariantDict* options);
static void baobab_application_real_shutdown (GApplication* base);
BaobabApplication* baobab_application_new (void);
BaobabApplication* baobab_application_construct (GType object_type);
static void baobab_application_finalize (GObject* obj);
static void _vala_baobab_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_application_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry BAOBAB_APPLICATION_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print version information and exit", NULL}, {NULL}};
static const GActionEntry BAOBAB_APPLICATION_action_entries[1] = {{"quit", _baobab_application_on_quit_activate_gsimple_action_activate_callback}};

static void _baobab_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_application_on_quit_activate ((BaobabApplication*) self);
}


static void baobab_application_real_activate (GApplication* base) {
	BaobabApplication * self;
	BaobabWindow* _tmp0_ = NULL;
	BaobabWindow* _tmp1_ = NULL;
	self = (BaobabApplication*) base;
	_tmp0_ = baobab_window_new (self);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	BaobabApplication * self;
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (BaobabApplication*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = files;
	_tmp0__length1 = files_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _tmp0_;
		file_collection_length1 = _tmp0__length1;
		for (file_it = 0; file_it < _tmp0__length1; file_it = file_it + 1) {
			GFile* _tmp1_ = NULL;
			GFile* file = NULL;
			_tmp1_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp1_;
			{
				BaobabWindow* window = NULL;
				BaobabWindow* _tmp2_ = NULL;
				BaobabWindow* _tmp3_ = NULL;
				GFile* _tmp4_ = NULL;
				_tmp2_ = baobab_window_new (self);
				g_object_ref_sink (_tmp2_);
				window = _tmp2_;
				_tmp3_ = window;
				_tmp4_ = file;
				baobab_window_scan_directory (_tmp3_, _tmp4_, BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS);
				_g_object_unref0 (window);
				_g_object_unref0 (file);
			}
		}
	}
}


BaobabApplication* baobab_application_get_default (void) {
	BaobabApplication* result = NULL;
	GApplication* _tmp0_ = NULL;
	BaobabApplication* _tmp1_ = NULL;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BAOBAB_TYPE_APPLICATION, BaobabApplication));
	result = _tmp1_;
	return result;
}


static guint _g_file_hash_ghash_func (gconstpointer key) {
	guint result;
	result = g_file_hash (key);
	return result;
}


static gboolean _g_file_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = g_file_equal (a, (GFile*) b);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


GHashTable* baobab_application_get_excluded_locations (BaobabApplication* self) {
	GHashTable* result = NULL;
	GHashTable* excluded_locations = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* home = NULL;
	const gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* root = NULL;
	GFile* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, NULL, _g_object_unref0_);
	excluded_locations = _tmp0_;
	_tmp1_ = excluded_locations;
	_tmp2_ = g_file_new_for_path ("/proc");
	g_hash_table_add (_tmp1_, _tmp2_);
	_tmp3_ = excluded_locations;
	_tmp4_ = g_file_new_for_path ("/sys");
	g_hash_table_add (_tmp3_, _tmp4_);
	_tmp5_ = excluded_locations;
	_tmp6_ = g_file_new_for_path ("/selinux");
	g_hash_table_add (_tmp5_, _tmp6_);
	_tmp7_ = g_get_home_dir ();
	_tmp8_ = g_file_new_for_path (_tmp7_);
	home = _tmp8_;
	_tmp9_ = excluded_locations;
	_tmp10_ = home;
	_tmp11_ = g_file_get_child (_tmp10_, ".gvfs");
	g_hash_table_add (_tmp9_, _tmp11_);
	_tmp12_ = g_file_new_for_path ("/");
	root = _tmp12_;
	{
		GVariantIter* _uri_it = NULL;
		GSettings* _tmp13_ = NULL;
		GVariant* _tmp14_ = NULL;
		GVariant* _tmp15_ = NULL;
		GVariantIter* _tmp16_ = NULL;
		GVariantIter* _tmp17_ = NULL;
		GVariant* uri = NULL;
		_tmp13_ = self->priv->_prefs_settings;
		_tmp14_ = g_settings_get_value (_tmp13_, "excluded-uris");
		_tmp15_ = _tmp14_;
		_tmp16_ = g_variant_iter_new (_tmp15_);
		_tmp17_ = _tmp16_;
		_g_variant_unref0 (_tmp15_);
		_uri_it = _tmp17_;
		while (TRUE) {
			GVariantIter* _tmp18_ = NULL;
			GVariant* _tmp19_ = NULL;
			GVariant* _tmp20_ = NULL;
			GFile* file = NULL;
			GVariant* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			GFile* _tmp24_ = NULL;
			GFile* _tmp25_ = NULL;
			GFile* _tmp26_ = NULL;
			GFile* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
			_tmp18_ = _uri_it;
			_tmp19_ = g_variant_iter_next_value (_tmp18_);
			_g_variant_unref0 (uri);
			uri = _tmp19_;
			_tmp20_ = uri;
			if (!(_tmp20_ != NULL)) {
				break;
			}
			_tmp21_ = uri;
			_tmp22_ = _variant_get1 (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_file_new_for_uri (_tmp23_);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp23_);
			file = _tmp25_;
			_tmp26_ = file;
			_tmp27_ = root;
			_tmp28_ = g_file_equal (_tmp26_, _tmp27_);
			if (!_tmp28_) {
				GHashTable* _tmp29_ = NULL;
				GFile* _tmp30_ = NULL;
				GFile* _tmp31_ = NULL;
				_tmp29_ = excluded_locations;
				_tmp30_ = file;
				_tmp31_ = _g_object_ref0 (_tmp30_);
				g_hash_table_add (_tmp29_, _tmp31_);
			}
			_g_object_unref0 (file);
		}
		_g_variant_unref0 (uri);
		_g_variant_iter_free0 (_uri_it);
	}
	result = excluded_locations;
	_g_object_unref0 (root);
	_g_object_unref0 (home);
	return result;
}


static void baobab_application_real_startup (GApplication* base) {
	BaobabApplication * self;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_ = NULL;
	GFile* css_file = NULL;
	GFile* _tmp1_ = NULL;
	GdkScreen* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (BaobabApplication*) base;
	G_APPLICATION_CLASS (baobab_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	_tmp1_ = g_file_new_for_uri ("resource:///org/gnome/baobab/baobab.css");
	css_file = _tmp1_;
	{
		gtk_css_provider_load_from_file (css_provider, css_file, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("baobab-application.vala:83: loading css: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (css_file);
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp4_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp5_ = g_settings_new ("org.gnome.baobab.ui");
	_tmp6_ = _tmp5_;
	baobab_application_set_ui_settings (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = g_settings_new ("org.gnome.baobab.preferences");
	_tmp8_ = _tmp7_;
	baobab_application_set_prefs_settings (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->_ui_settings;
	g_settings_delay (_tmp9_);
	_tmp10_ = g_strdup ("F10");
	_tmp11_ = g_new0 (gchar*, 1 + 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.gear-menu", _tmp12_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = g_strdup ("<Primary>r");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.reload", _tmp15_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (css_file);
	_g_object_unref0 (css_provider);
}


static gint baobab_application_real_handle_local_options (GApplication* base, GVariantDict* options) {
	BaobabApplication * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (BaobabApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = g_get_application_name ();
		g_print ("%s %s\n", _tmp2_, VERSION);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}


static void baobab_application_real_shutdown (GApplication* base) {
	BaobabApplication * self;
	GSettings* _tmp0_ = NULL;
	self = (BaobabApplication*) base;
	_tmp0_ = self->priv->_ui_settings;
	g_settings_apply (_tmp0_);
	G_APPLICATION_CLASS (baobab_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}


BaobabApplication* baobab_application_construct (GType object_type) {
	BaobabApplication * self = NULL;
	self = (BaobabApplication*) g_object_new (object_type, "application-id", "org.gnome.baobab", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	g_application_add_main_option_entries ((GApplication*) self, BAOBAB_APPLICATION_option_entries);
	g_action_map_add_action_entries ((GActionMap*) self, BAOBAB_APPLICATION_action_entries, G_N_ELEMENTS (BAOBAB_APPLICATION_action_entries), self);
	return self;
}


BaobabApplication* baobab_application_new (void) {
	return baobab_application_construct (BAOBAB_TYPE_APPLICATION);
}


static void baobab_application_on_quit_activate (BaobabApplication* self) {
	g_return_if_fail (self != NULL);
	g_application_quit ((GApplication*) self);
}


GSettings* baobab_application_get_prefs_settings (BaobabApplication* self) {
	GSettings* result;
	GSettings* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prefs_settings;
	result = _tmp0_;
	return result;
}


static void baobab_application_set_prefs_settings (BaobabApplication* self, GSettings* value) {
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_prefs_settings);
	self->priv->_prefs_settings = _tmp1_;
	g_object_notify ((GObject *) self, "prefs-settings");
}


GSettings* baobab_application_get_ui_settings (BaobabApplication* self) {
	GSettings* result;
	GSettings* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ui_settings;
	result = _tmp0_;
	return result;
}


static void baobab_application_set_ui_settings (BaobabApplication* self, GSettings* value) {
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_ui_settings);
	self->priv->_ui_settings = _tmp1_;
	g_object_notify ((GObject *) self, "ui-settings");
}


static void baobab_application_class_init (BaobabApplicationClass * klass) {
	baobab_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabApplicationPrivate));
	((GApplicationClass *) klass)->activate = baobab_application_real_activate;
	((GApplicationClass *) klass)->open = baobab_application_real_open;
	((GApplicationClass *) klass)->startup = baobab_application_real_startup;
	((GApplicationClass *) klass)->handle_local_options = baobab_application_real_handle_local_options;
	((GApplicationClass *) klass)->shutdown = baobab_application_real_shutdown;
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_application_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_APPLICATION_PREFS_SETTINGS, g_param_spec_object ("prefs-settings", "prefs-settings", "prefs-settings", G_TYPE_SETTINGS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_APPLICATION_UI_SETTINGS, g_param_spec_object ("ui-settings", "ui-settings", "ui-settings", G_TYPE_SETTINGS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void baobab_application_instance_init (BaobabApplication * self) {
	self->priv = BAOBAB_APPLICATION_GET_PRIVATE (self);
}


static void baobab_application_finalize (GObject* obj) {
	BaobabApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_APPLICATION, BaobabApplication);
	_g_object_unref0 (self->priv->_prefs_settings);
	_g_object_unref0 (self->priv->_ui_settings);
	G_OBJECT_CLASS (baobab_application_parent_class)->finalize (obj);
}


GType baobab_application_get_type (void) {
	static volatile gsize baobab_application_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabApplication), 0, (GInstanceInitFunc) baobab_application_instance_init, NULL };
		GType baobab_application_type_id;
		baobab_application_type_id = g_type_register_static (gtk_application_get_type (), "BaobabApplication", &g_define_type_info, 0);
		g_once_init_leave (&baobab_application_type_id__volatile, baobab_application_type_id);
	}
	return baobab_application_type_id__volatile;
}


static void _vala_baobab_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_APPLICATION, BaobabApplication);
	switch (property_id) {
		case BAOBAB_APPLICATION_PREFS_SETTINGS:
		g_value_set_object (value, baobab_application_get_prefs_settings (self));
		break;
		case BAOBAB_APPLICATION_UI_SETTINGS:
		g_value_set_object (value, baobab_application_get_ui_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_application_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_APPLICATION, BaobabApplication);
	switch (property_id) {
		case BAOBAB_APPLICATION_PREFS_SETTINGS:
		baobab_application_set_prefs_settings (self, g_value_get_object (value));
		break;
		case BAOBAB_APPLICATION_UI_SETTINGS:
		baobab_application_set_ui_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



