; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals
; This test checks to make sure that constant exprs fold in some simple
; situations

; RUN: opt -S < %s | FileCheck %s
; RUN: llvm-as < %s | llvm-dis | FileCheck %s
; RUN: verify-uselistorder %s

@A = global i64 0

@add = global ptr inttoptr (i64 add (i64 ptrtoint (ptr @A to i64), i64 0) to ptr) ; X + 0 == X
@sub = global ptr inttoptr (i64 sub (i64 ptrtoint (ptr @A to i64), i64 0) to ptr) ; X - 0 == X
@mul = global ptr inttoptr (i64 mul (i64 ptrtoint (ptr @A to i64), i64 0) to ptr) ; X * 0 == 0
@xor = global ptr inttoptr (i64 xor (i64 ptrtoint (ptr @A to i64), i64 0) to ptr) ; X ^ 0 == X

%Ty = type { i32, i32 }
@B = external global %Ty

; PR2206
@cons = weak global i32 0, align 8              ; <ptr> [#uses=1]

@gep1 = global <2 x ptr> getelementptr(i8, <2 x ptr> undef, <2 x i64> <i64 1, i64 1>)
@gep2 = global <2 x ptr> getelementptr({ i8 }, <2 x ptr> undef, <2 x i64> <i64 1, i64 1>, <2 x i32> <i32 0, i32 0>)
@gep3 = global <2 x ptr> getelementptr(i8, <2 x ptr> zeroinitializer, <2 x i64> <i64 0, i64 0>)
@gep4 = global <2 x ptr> getelementptr({ i8 }, <2 x ptr> zeroinitializer, <2 x i64> <i64 0, i64 0>, <2 x i32> <i32 0, i32 0>)

@bitcast1 = global <2 x i32> bitcast (<4 x i16> <i16 -1, i16 -1, i16 -1, i16 -1> to <2 x i32>)
@bitcast2 = global <4 x i16> bitcast (<2 x i32> <i32 -1, i32 -1> to <4 x i16>)


; Need a function to make update_test_checks.py work.
;.
; CHECK: @A = global i64 0
; CHECK: @add = global ptr @A
; CHECK: @sub = global ptr @A
; CHECK: @mul = global ptr null
; CHECK: @xor = global ptr @A
; CHECK: @B = external global %Ty
; CHECK: @cons = weak global i32 0, align 8
; CHECK: @gep1 = global <2 x ptr> undef
; CHECK: @gep2 = global <2 x ptr> undef
; CHECK: @gep3 = global <2 x ptr> zeroinitializer
; CHECK: @gep4 = global <2 x ptr> zeroinitializer
; CHECK: @bitcast1 = global <2 x i32> splat (i32 -1)
; CHECK: @bitcast2 = global <4 x i16> splat (i16 -1)
;.
define void @dummy() {
; CHECK-LABEL: @dummy(
; CHECK-NEXT:    ret void
;
  ret void
}
