; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
; These tests check the optimizations specific to
; pointers being relocated at a statepoint.


declare ptr @fake_personality_function()
declare void @func()

define i1 @test_negative(ptr addrspace(1) %p) gc "statepoint-example" {
; CHECK-LABEL: @test_negative(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SAFEPOINT_TOKEN:%.*]] = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr nonnull elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) [ "gc-live"(ptr addrspace(1) [[P:%.*]]) ]
; CHECK-NEXT:    [[PNEW:%.*]] = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[SAFEPOINT_TOKEN]], i32 0, i32 0)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr addrspace(1) [[PNEW]], null
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) ["gc-live"(ptr addrspace(1) %p)]
  %pnew = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %safepoint_token,  i32 0, i32 0)
  %cmp = icmp eq ptr addrspace(1) %pnew, null
  ret i1 %cmp
}

define i1 @test_nonnull(ptr addrspace(1) nonnull %p) gc "statepoint-example" {
; CHECK-LABEL: @test_nonnull(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SAFEPOINT_TOKEN:%.*]] = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr nonnull elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) [ "gc-live"() ]
; CHECK-NEXT:    ret i1 false
;
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) ["gc-live"(ptr addrspace(1) %p)]
  %pnew = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %safepoint_token,  i32 0, i32 0)
  %cmp = icmp eq ptr addrspace(1) %pnew, null
  ret i1 %cmp
}

define i1 @test_null() gc "statepoint-example" {
; CHECK-LABEL: @test_null(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SAFEPOINT_TOKEN:%.*]] = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr nonnull elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) [ "gc-live"() ]
; CHECK-NEXT:    ret i1 true
;
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) ["gc-live"(ptr addrspace(1) null)]
  %pnew = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %safepoint_token,  i32 0, i32 0)
  %cmp = icmp eq ptr addrspace(1) %pnew, null
  ret i1 %cmp
}

define i1 @test_undef() gc "statepoint-example" {
; CHECK-LABEL: @test_undef(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SAFEPOINT_TOKEN:%.*]] = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr nonnull elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) [ "gc-live"() ]
; CHECK-NEXT:    ret i1 undef
;
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) ["gc-live"(ptr addrspace(1) undef)]
  %pnew = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %safepoint_token,  i32 0, i32 0)
  %cmp = icmp eq ptr addrspace(1) %pnew, null
  ret i1 %cmp
}

define i1 @test_negative_invoke(ptr addrspace(1) %p) gc "statepoint-example" personality ptr @fake_personality_function {
; CHECK-LABEL: @test_negative_invoke(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SAFEPOINT_TOKEN:%.*]] = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr nonnull elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) [ "gc-live"(ptr addrspace(1) [[P:%.*]]) ]
; CHECK-NEXT:    to label [[NORMAL_DEST:%.*]] unwind label [[UNWIND_DEST:%.*]]
; CHECK:       normal_dest:
; CHECK-NEXT:    [[PNEW:%.*]] = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[SAFEPOINT_TOKEN]], i32 0, i32 0)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr addrspace(1) [[PNEW]], null
; CHECK-NEXT:    ret i1 [[CMP]]
; CHECK:       unwind_dest:
; CHECK-NEXT:    [[LPAD:%.*]] = landingpad token
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    [[PNEW2:%.*]] = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[LPAD]], i32 0, i32 0)
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ne ptr addrspace(1) [[PNEW2]], null
; CHECK-NEXT:    ret i1 [[CMP2]]
;
entry:
  %safepoint_token = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) ["gc-live"(ptr addrspace(1) %p)]
  to label %normal_dest unwind label %unwind_dest

normal_dest:
  %pnew = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %safepoint_token,  i32 0, i32 0)
  %cmp = icmp eq ptr addrspace(1) %pnew, null
  ret i1 %cmp
unwind_dest:
  %lpad = landingpad token
  cleanup
  %pnew2 = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %lpad,  i32 0, i32 0)
  %cmp2 = icmp ne ptr addrspace(1) %pnew2, null
  ret i1 %cmp2
}

define i1 @test_nonnull_invoke(ptr addrspace(1) nonnull %p) gc "statepoint-example" personality ptr @fake_personality_function {
; CHECK-LABEL: @test_nonnull_invoke(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SAFEPOINT_TOKEN:%.*]] = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr nonnull elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) [ "gc-live"() ]
; CHECK-NEXT:    to label [[NORMAL_DEST:%.*]] unwind label [[UNWIND_DEST:%.*]]
; CHECK:       normal_dest:
; CHECK-NEXT:    ret i1 false
; CHECK:       unwind_dest:
; CHECK-NEXT:    [[LPAD:%.*]] = landingpad token
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    ret i1 true
;
entry:
  %safepoint_token = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) ["gc-live"(ptr addrspace(1) %p)]
  to label %normal_dest unwind label %unwind_dest

normal_dest:
  %pnew = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %safepoint_token,  i32 0, i32 0)
  %cmp = icmp eq ptr addrspace(1) %pnew, null
  ret i1 %cmp
unwind_dest:
  %lpad = landingpad token
  cleanup
  %pnew2 = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %lpad,  i32 0, i32 0)
  %cmp2 = icmp ne ptr addrspace(1) %pnew2, null
  ret i1 %cmp2
}

define i1 @test_null_invoke() gc "statepoint-example" personality ptr @fake_personality_function {
; CHECK-LABEL: @test_null_invoke(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SAFEPOINT_TOKEN:%.*]] = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr nonnull elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) [ "gc-live"() ]
; CHECK-NEXT:    to label [[NORMAL_DEST:%.*]] unwind label [[UNWIND_DEST:%.*]]
; CHECK:       normal_dest:
; CHECK-NEXT:    ret i1 true
; CHECK:       unwind_dest:
; CHECK-NEXT:    [[LPAD:%.*]] = landingpad token
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    ret i1 false
;
entry:
  %safepoint_token = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) ["gc-live"(ptr addrspace(1) null)]
  to label %normal_dest unwind label %unwind_dest

normal_dest:
  %pnew = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %safepoint_token,  i32 0, i32 0)
  %cmp = icmp eq ptr addrspace(1) %pnew, null
  ret i1 %cmp
unwind_dest:
  %lpad = landingpad token
  cleanup
  %pnew2 = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %lpad,  i32 0, i32 0)
  %cmp2 = icmp ne ptr addrspace(1) %pnew2, null
  ret i1 %cmp2
}

define i1 @test_undef_invoke() gc "statepoint-example" personality ptr @fake_personality_function {
; CHECK-LABEL: @test_undef_invoke(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SAFEPOINT_TOKEN:%.*]] = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr nonnull elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) [ "gc-live"() ]
; CHECK-NEXT:    to label [[NORMAL_DEST:%.*]] unwind label [[UNWIND_DEST:%.*]]
; CHECK:       normal_dest:
; CHECK-NEXT:    ret i1 undef
; CHECK:       unwind_dest:
; CHECK-NEXT:    [[LPAD:%.*]] = landingpad token
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    ret i1 undef
;
entry:
  %safepoint_token = invoke token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void ()) @func, i32 0, i32 0, i32 0, i32 0) ["gc-live"(ptr addrspace(1) undef)]
  to label %normal_dest unwind label %unwind_dest

normal_dest:
  %pnew = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %safepoint_token,  i32 0, i32 0)
  %cmp = icmp eq ptr addrspace(1) %pnew, null
  ret i1 %cmp
unwind_dest:
  %lpad = landingpad token
  cleanup
  %pnew2 = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %lpad,  i32 0, i32 0)
  %cmp2 = icmp ne ptr addrspace(1) %pnew2, null
  ret i1 %cmp2
}

declare token @llvm.experimental.gc.statepoint.p0(i64, i32, ptr, i32, i32, ...)
declare ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token, i32, i32) #3
