; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=loop-vectorize -force-vector-width=4 -force-vector-interleave=1 -S %s | FileCheck %s

define i32 @sink_load_that_uses_for_past_other_loads(ptr noalias %A, ptr noalias %B) {
; CHECK-LABEL: @sink_load_that_uses_for_past_other_loads(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[FOR:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[FOR_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[RED:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[RED_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_A:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i32 [[FOR]]
; CHECK-NEXT:    [[L_A:%.*]] = load i32, ptr [[GEP_A]], align 4
; CHECK-NEXT:    [[GEP_B:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i32 [[IV]]
; CHECK-NEXT:    [[FOR_NEXT]] = load i32, ptr [[GEP_B]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[FOR]], [[L_A]]
; CHECK-NEXT:    [[RED_NEXT]] = add i32 [[RED]], [[ADD]]
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], 1000
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[RED_NEXT_LCSSA:%.*]] = phi i32 [ [[RED_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i32 [[RED_NEXT_LCSSA]]
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %for = phi i32 [ 0, %entry ], [ %for.next, %loop ]
  %red = phi i32 [ 0, %entry ], [ %red.next, %loop ]
  %gep.a = getelementptr inbounds i32, ptr %A, i32 %for
  %l.a = load i32, ptr %gep.a
  %gep.b = getelementptr inbounds i32, ptr %B, i32 %iv
  %for.next = load i32, ptr %gep.b
  %add = add i32 %for, %l.a
  %red.next = add i32 %red, %add
  %iv.next = add nuw nsw i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 1000
  br i1 %ec, label %exit, label %loop

exit:
  ret i32 %red.next
}

define void @cannot_sink_load_past_mayalias_store(ptr noalias %A, ptr noalias %B) {
; CHECK-LABEL: @cannot_sink_load_past_mayalias_store(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[FOR:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[FOR_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_A:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i32 [[FOR]]
; CHECK-NEXT:    [[L_A:%.*]] = load i32, ptr [[GEP_A]], align 4
; CHECK-NEXT:    [[GEP_A_2:%.*]] = getelementptr inbounds i32, ptr [[A]], i32 [[IV]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[FOR]], [[L_A]]
; CHECK-NEXT:    store i32 [[ADD]], ptr [[GEP_A_2]], align 4
; CHECK-NEXT:    [[FOR_NEXT]] = load i32, ptr [[GEP_A_2]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], 1000
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %for = phi i32 [ 0, %entry ], [ %for.next, %loop ]
  %gep.a = getelementptr inbounds i32, ptr %A, i32 %for
  %l.a = load i32, ptr %gep.a
  %gep.a.2 = getelementptr inbounds i32, ptr %A, i32 %iv
  %add = add i32 %for, %l.a
  store i32 %add, ptr %gep.a.2
  %for.next = load i32, ptr %gep.a.2
  %iv.next = add nuw nsw i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 1000
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @sink_store_that_uses_for_past_instructions(ptr noalias %A, ptr noalias %B) {
; CHECK-LABEL: @sink_store_that_uses_for_past_instructions(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[FOR:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[FOR_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_A:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i32 [[IV]]
; CHECK-NEXT:    store i32 [[FOR]], ptr [[GEP_A]], align 4
; CHECK-NEXT:    [[FOR_NEXT]] = add i32 [[IV]], 2
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], 1000
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %for = phi i32 [ 0, %entry ], [ %for.next, %loop ]
  %gep.a = getelementptr inbounds i32, ptr %A, i32 %iv
  store i32 %for, ptr %gep.a
  %for.next = add i32 %iv, 2
  %iv.next = add nuw nsw i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 1000
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @sink_store_past_non_aliasing_load(ptr noalias %A, ptr noalias %B) {
; CHECK-LABEL: @sink_store_past_non_aliasing_load(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[FOR:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[FOR_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_A:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i32 [[IV]]
; CHECK-NEXT:    store i32 [[FOR]], ptr [[GEP_A]], align 4
; CHECK-NEXT:    [[GEP_B:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i32 [[IV]]
; CHECK-NEXT:    [[FOR_NEXT]] = load i32, ptr [[GEP_B]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], 1000
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %for = phi i32 [ 0, %entry ], [ %for.next, %loop ]
  %gep.a = getelementptr inbounds i32, ptr %A, i32 %iv
  store i32 %for, ptr %gep.a
  %gep.b = getelementptr inbounds i32, ptr %B, i32 %iv
  %for.next = load i32, ptr %gep.b
  %iv.next = add nuw nsw i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 1000
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @sink_store_past_aliasing_load(ptr %A, ptr %B) {
; CHECK-LABEL: @sink_store_past_aliasing_load(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[FOR:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[FOR_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_A:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i32 [[IV]]
; CHECK-NEXT:    store i32 [[FOR]], ptr [[GEP_A]], align 4
; CHECK-NEXT:    [[GEP_B:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i32 [[IV]]
; CHECK-NEXT:    [[FOR_NEXT]] = load i32, ptr [[GEP_B]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], 1000
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %for = phi i32 [ 0, %entry ], [ %for.next, %loop ]
  %gep.a = getelementptr inbounds i32, ptr %A, i32 %iv
  store i32 %for, ptr %gep.a
  %gep.b = getelementptr inbounds i32, ptr %B, i32 %iv
  %for.next = load i32, ptr %gep.b
  %iv.next = add nuw nsw i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 1000
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @sink_store_past_non_aliasing_store(ptr noalias %A, ptr noalias %B) {
; CHECK-LABEL: @sink_store_past_non_aliasing_store(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[FOR:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[FOR_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_A:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i32 [[IV]]
; CHECK-NEXT:    store i32 [[FOR]], ptr [[GEP_A]], align 4
; CHECK-NEXT:    [[GEP_B:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i32 [[IV]]
; CHECK-NEXT:    store i32 123, ptr [[GEP_B]], align 4
; CHECK-NEXT:    [[FOR_NEXT]] = add i32 [[IV]], 2
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], 1000
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %for = phi i32 [ 0, %entry ], [ %for.next, %loop ]
  %gep.a = getelementptr inbounds i32, ptr %A, i32 %iv
  store i32 %for, ptr %gep.a
  %gep.b = getelementptr inbounds i32, ptr %B, i32 %iv
  store i32 123, ptr %gep.b
  %for.next = add i32 %iv, 2
  %iv.next = add nuw nsw i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 1000
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @sink_store_past_aliasing_store(ptr %A, ptr %B) {
; CHECK-LABEL: @sink_store_past_aliasing_store(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[FOR:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[FOR_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_A:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i32 [[IV]]
; CHECK-NEXT:    store i32 [[FOR]], ptr [[GEP_A]], align 4
; CHECK-NEXT:    [[GEP_B:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i32 [[IV]]
; CHECK-NEXT:    store i32 123, ptr [[GEP_B]], align 4
; CHECK-NEXT:    [[FOR_NEXT]] = add i32 [[IV]], 2
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], 1000
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %for = phi i32 [ 0, %entry ], [ %for.next, %loop ]
  %gep.a = getelementptr inbounds i32, ptr %A, i32 %iv
  store i32 %for, ptr %gep.a
  %gep.b = getelementptr inbounds i32, ptr %B, i32 %iv
  store i32 123, ptr %gep.b
  %for.next = add i32 %iv, 2
  %iv.next = add nuw nsw i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 1000
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}
