// RUN: llvm-mc -triple=aarch64 -show-encoding -mattr=+sve2 < %s \
// RUN:        | FileCheck %s --check-prefixes=CHECK-ENCODING,CHECK-INST
// RUN: llvm-mc -triple=aarch64 -show-encoding -mattr=+sme < %s \
// RUN:        | FileCheck %s --check-prefixes=CHECK-ENCODING,CHECK-INST
// RUN: not llvm-mc -triple=aarch64 -show-encoding < %s 2>&1 \
// RUN:        | FileCheck %s --check-prefix=CHECK-ERROR
// RUN: llvm-mc -triple=aarch64 -filetype=obj -mattr=+sve2 < %s \
// RUN:        | llvm-objdump --no-print-imm-hex -d --mattr=+sve2 - | FileCheck %s --check-prefix=CHECK-INST
// RUN: llvm-mc -triple=aarch64 -filetype=obj -mattr=+sve2 < %s \
// RUN:   | llvm-objdump --no-print-imm-hex -d --mattr=-sve2 - | FileCheck %s --check-prefix=CHECK-UNKNOWN

uqshl z0.b, p0/m, z0.b, z1.b
// CHECK-INST: uqshl z0.b, p0/m, z0.b, z1.b
// CHECK-ENCODING: [0x20,0x80,0x09,0x44]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 44098020 <unknown>

uqshl z0.h, p0/m, z0.h, z1.h
// CHECK-INST: uqshl z0.h, p0/m, z0.h, z1.h
// CHECK-ENCODING: [0x20,0x80,0x49,0x44]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 44498020 <unknown>

uqshl z29.s, p7/m, z29.s, z30.s
// CHECK-INST: uqshl z29.s, p7/m, z29.s, z30.s
// CHECK-ENCODING: [0xdd,0x9f,0x89,0x44]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 44899fdd <unknown>

uqshl z31.d, p7/m, z31.d, z30.d
// CHECK-INST: uqshl z31.d, p7/m, z31.d, z30.d
// CHECK-ENCODING: [0xdf,0x9f,0xc9,0x44]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 44c99fdf <unknown>

uqshl z0.b, p0/m, z0.b, #0
// CHECK-INST: uqshl z0.b, p0/m, z0.b, #0
// CHECK-ENCODING: [0x00,0x81,0x07,0x04]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 04078100 <unknown>

uqshl z31.b, p0/m, z31.b, #7
// CHECK-INST: uqshl z31.b, p0/m, z31.b, #7
// CHECK-ENCODING: [0xff,0x81,0x07,0x04]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 040781ff <unknown>

uqshl z0.h, p0/m, z0.h, #0
// CHECK-INST: uqshl z0.h, p0/m, z0.h, #0
// CHECK-ENCODING: [0x00,0x82,0x07,0x04]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 04078200 <unknown>

uqshl z31.h, p0/m, z31.h, #15
// CHECK-INST: uqshl z31.h, p0/m, z31.h, #15
// CHECK-ENCODING: [0xff,0x83,0x07,0x04]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 040783ff <unknown>

uqshl z0.s, p0/m, z0.s, #0
// CHECK-INST: uqshl z0.s, p0/m, z0.s, #0
// CHECK-ENCODING: [0x00,0x80,0x47,0x04]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 04478000 <unknown>

uqshl z31.s, p0/m, z31.s, #31
// CHECK-INST: uqshl z31.s, p0/m, z31.s, #31
// CHECK-ENCODING: [0xff,0x83,0x47,0x04]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 044783ff <unknown>

uqshl z0.d, p0/m, z0.d, #0
// CHECK-INST: uqshl z0.d, p0/m, z0.d, #0
// CHECK-ENCODING: [0x00,0x80,0x87,0x04]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 04878000 <unknown>

uqshl z31.d, p0/m, z31.d, #63
// CHECK-INST: uqshl z31.d, p0/m, z31.d, #63
// CHECK-ENCODING: [0xff,0x83,0xc7,0x04]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 04c783ff <unknown>

// --------------------------------------------------------------------------//
// Test compatibility with MOVPRFX instruction.

movprfx z31.d, p0/z, z6.d
// CHECK-INST: movprfx z31.d, p0/z, z6.d
// CHECK-ENCODING: [0xdf,0x20,0xd0,0x04]
// CHECK-ERROR: instruction requires: sve or sme
// CHECK-UNKNOWN: 04d020df <unknown>

uqshl z31.d, p0/m, z31.d, z30.d
// CHECK-INST: uqshl z31.d, p0/m, z31.d, z30.d
// CHECK-ENCODING: [0xdf,0x83,0xc9,0x44]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 44c983df <unknown>

movprfx z31, z6
// CHECK-INST: movprfx z31, z6
// CHECK-ENCODING: [0xdf,0xbc,0x20,0x04]
// CHECK-ERROR: instruction requires: sve or sme
// CHECK-UNKNOWN: 0420bcdf <unknown>

uqshl z31.d, p7/m, z31.d, z30.d
// CHECK-INST: uqshl z31.d, p7/m, z31.d, z30.d
// CHECK-ENCODING: [0xdf,0x9f,0xc9,0x44]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 44c99fdf <unknown>

movprfx z31.d, p0/z, z6.d
// CHECK-INST: movprfx z31.d, p0/z, z6.d
// CHECK-ENCODING: [0xdf,0x20,0xd0,0x04]
// CHECK-ERROR: instruction requires: sve or sme
// CHECK-UNKNOWN: 04d020df <unknown>

uqshl z31.d, p0/m, z31.d, #63
// CHECK-INST: uqshl z31.d, p0/m, z31.d, #63
// CHECK-ENCODING: [0xff,0x83,0xc7,0x04]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 04c783ff <unknown>

movprfx z31, z6
// CHECK-INST: movprfx z31, z6
// CHECK-ENCODING: [0xdf,0xbc,0x20,0x04]
// CHECK-ERROR: instruction requires: sve or sme
// CHECK-UNKNOWN: 0420bcdf <unknown>

uqshl z31.d, p0/m, z31.d, #63
// CHECK-INST: uqshl z31.d, p0/m, z31.d, #63
// CHECK-ENCODING: [0xff,0x83,0xc7,0x04]
// CHECK-ERROR: instruction requires: sve2 or sme
// CHECK-UNKNOWN: 04c783ff <unknown>
