; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple=amdgcn-amd-amdhsa -passes=instcombine -S | FileCheck %s

; Optimize the intrinsic away if the argument is uniform.
define i32 @test_constant() {
; CHECK-LABEL: @test_constant(
; CHECK-NEXT:    ret i32 99
;
  %call = call i32 @llvm.amdgcn.permlane64.i32(i32 99)
  ret i32 %call
}

define i32 @test_bitcast_f32_to_i32_permlane64(float %val) {
; CHECK-LABEL: @test_bitcast_f32_to_i32_permlane64(
; CHECK-NEXT:    [[VAL:%.*]] = call float @llvm.amdgcn.permlane64.f32(float [[VAL1:%.*]])
; CHECK-NEXT:    [[BITCAST:%.*]] = bitcast float [[VAL]] to i32
; CHECK-NEXT:    ret i32 [[BITCAST]]
;
  %bitcast = bitcast float %val to i32
  %result = call i32 @llvm.amdgcn.permlane64.i32(i32 %bitcast)
  ret i32 %result
}

define i32 @test_bitcast_f32_to_i32_permlane64_convergencetokenn(float %val) convergent {
; CHECK-LABEL: @test_bitcast_f32_to_i32_permlane64_convergencetokenn(
; CHECK-NEXT:    [[T:%.*]] = call token @llvm.experimental.convergence.entry()
; CHECK-NEXT:    [[VAL:%.*]] = call float @llvm.amdgcn.permlane64.f32(float [[VAL1:%.*]]) [ "convergencectrl"(token [[T]]) ]
; CHECK-NEXT:    [[BITCAST:%.*]] = bitcast float [[VAL]] to i32
; CHECK-NEXT:    ret i32 [[BITCAST]]
;
  %t = call token @llvm.experimental.convergence.entry()
  %bitcast = bitcast float %val to i32
  %result = call i32 @llvm.amdgcn.permlane64.i32(i32 %bitcast) [ "convergencectrl"(token %t) ]
  ret i32 %result
}

declare i32 @llvm.amdgcn.permlane64.i32(i32)
