; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

; Tests for select to scmp

define i32 @scmp_x_0_inverted(i32 %x) {
; CHECK-LABEL: define i32 @scmp_x_0_inverted(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.scmp.i32.i32(i32 [[X]], i32 0)
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %2 = icmp ne i32 %x, 0
  %3 = zext i1 %2 to i32
  %4 = icmp sgt i32 %x, -1
  %5 = select i1 %4, i32 %3, i32 -1
  ret i32 %5
}

; y = -10
define i32 @scmp_x_0_inverted_const_neg10(i32 %x) {
; CHECK-LABEL: define i32 @scmp_x_0_inverted_const_neg10(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.scmp.i32.i32(i32 [[X]], i32 -10)
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %1 = icmp ne i32 %x, -10
  %2 = zext i1 %1 to i32
  %3 = icmp sgt i32 %x, -11
  %4 = select i1 %3, i32 %2, i32 -1
  ret i32 %4
}

; y = 7 (i8)
define i8 @scmp_x_0_inverted_i8(i8 %x) {
; CHECK-LABEL: define i8 @scmp_x_0_inverted_i8(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.scmp.i8.i8(i8 [[X]], i8 7)
; CHECK-NEXT:    ret i8 [[TMP1]]
;
  %1 = icmp ne i8 %x, 7
  %2 = zext i1 %1 to i8
  %3 = icmp sgt i8 %x, 6
  %4 = select i1 %3, i8 %2, i8 -1
  ret i8 %4
}

; scmp using ints of two kinds- i32 and i64
define i32 @scmp_x_0_inverted_i64_neq(i32 %x) {
; CHECK-LABEL: define i32 @scmp_x_0_inverted_i64_neq(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = call i64 @llvm.scmp.i64.i32(i32 [[X]], i32 0)
; CHECK-NEXT:    [[RET:%.*]] = trunc i64 [[SEL]] to i32
; CHECK-NEXT:    ret i32 [[RET]]
;
  %x64 = sext i32 %x to i64
  %cmp1 = icmp ne i64 %x64, 0
  %zext = zext i1 %cmp1 to i64
  %cmp2 = icmp sgt i64 %x64, -1
  %sel = select i1 %cmp2, i64 %zext, i64 -1
  %ret = trunc i64 %sel to i32
  ret i32 %ret
}

; Same example as previous but with inequality
define i32 @scmp_x_0_inverted_i64_sgt(i32 %x) {
; CHECK-LABEL: define i32 @scmp_x_0_inverted_i64_sgt(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = call i64 @llvm.scmp.i64.i32(i32 [[X]], i32 0)
; CHECK-NEXT:    [[RET:%.*]] = trunc i64 [[SEL]] to i32
; CHECK-NEXT:    ret i32 [[RET]]
;
  %x64 = sext i32 %x to i64
  %cmp1 = icmp sgt i64 %x64, 0
  %zext = zext i1 %cmp1 to i64
  %cmp2 = icmp sgt i64 %x64, -1
  %sel = select i1 %cmp2, i64 %zext, i64 -1
  %ret = trunc i64 %sel to i32
  ret i32 %ret
}

; y = -1000
define i32 @scmp_x_0_inverted_const_neg1000(i32 %x) {
; CHECK-LABEL: define i32 @scmp_x_0_inverted_const_neg1000(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.scmp.i32.i32(i32 [[X]], i32 -1000)
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %1 = icmp sgt i32 %x, -1000
  %2 = zext i1 %1 to i32
  %3 = icmp sgt i32 %x, -1001
  %4 = select i1 %3, i32 %2, i32 -1
  ret i32 %4
}

; y = 1729
define i32 @scmp_x_0_inverted_const_1729_sgt(i32 %x) {
; CHECK-LABEL: define i32 @scmp_x_0_inverted_const_1729_sgt(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.scmp.i32.i32(i32 [[X]], i32 1729)
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %1 = icmp sgt i32 %x, 1729
  %2 = zext i1 %1 to i32
  %3 = icmp sgt i32 %x, 1728
  %4 = select i1 %3, i32 %2, i32 -1
  ret i32 %4
}

; ucmp with 10
define i32 @ucmp_x_10_inverted(i32 %x) {
; CHECK-LABEL: define i32 @ucmp_x_10_inverted(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.ucmp.i32.i32(i32 [[X]], i32 10)
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %1 = icmp ne i32 %x, 10
  %2 = zext i1 %1 to i32
  %3 = icmp ugt i32 %x, 9
  %4 = select i1 %3, i32 %2, i32 -1
  ret i32 %4
}

; ucmp with -3, wraps around
define i32 @ucmp_x_neg1_inverted(i32 %x) {
; CHECK-LABEL: define i32 @ucmp_x_neg1_inverted(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.ucmp.i32.i32(i32 [[X]], i32 -3)
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %1 = icmp ne i32 %x, -3
  %2 = zext i1 %1 to i32
  %3 = icmp ugt i32 %x, -4
  %4 = select i1 %3, i32 %2, i32 -1
  ret i32 %4
}

; ucmp with -4, wraps around
define i8 @ucmp_x_neg4_i8_ugt(i8 %x) {
; CHECK-LABEL: define i8 @ucmp_x_neg4_i8_ugt(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.ucmp.i8.i8(i8 [[X]], i8 -4)
; CHECK-NEXT:    ret i8 [[TMP1]]
;
  %1 = icmp ugt i8 %x, -4
  %2 = zext i1 %1 to i8
  %3 = icmp ugt i8 %x, -5
  %4 = select i1 %3, i8 %2, i8 -1
  ret i8 %4
}

; Vector tests

; Test with splat vec
define <4 x i32> @scmp_x_0_inverted_splat_vec(<4 x i32> %x) {
; CHECK-LABEL: define <4 x i32> @scmp_x_0_inverted_splat_vec(
; CHECK-SAME: <4 x i32> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.scmp.v4i32.v4i32(<4 x i32> [[X]], <4 x i32> zeroinitializer)
; CHECK-NEXT:    ret <4 x i32> [[TMP1]]
;
  %2 = icmp ne <4 x i32> %x, zeroinitializer
  %3 = zext <4 x i1> %2 to <4 x i32>
  %4 = icmp sgt <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %5 = select <4 x i1> %4, <4 x i32> %3, <4 x i32> <i32 -1, i32 -1, i32 -1, i32 -1>
  ret <4 x i32> %5
}

; Test with non-splat vector and different bitwidth
define <4 x i32> @non_splat_vec_scmp_diff_bitwidth(<4 x i32> %x) {
; CHECK-LABEL: define <4 x i32> @non_splat_vec_scmp_diff_bitwidth(
; CHECK-SAME: <4 x i32> [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = call <4 x i64> @llvm.scmp.v4i64.v4i32(<4 x i32> [[X]], <4 x i32> <i32 0, i32 1, i32 -1, i32 5>)
; CHECK-NEXT:    [[RET:%.*]] = trunc <4 x i64> [[SEL]] to <4 x i32>
; CHECK-NEXT:    ret <4 x i32> [[RET]]
;
  %x64 = sext <4 x i32> %x to <4 x i64>
  %cmp1 = icmp slt <4 x i64> %x64, <i64 0, i64 1, i64 -1, i64 5>
  %sext = sext <4 x i1> %cmp1 to <4 x i64>
  %cmp2 = icmp slt <4 x i64> %x64, <i64 1, i64 2, i64 0, i64 6>
  %sel = select <4 x i1> %cmp2, <4 x i64> %sext, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %ret = trunc <4 x i64> %sel to <4 x i32>
  ret <4 x i32> %ret
}

; Negative examples

; Not scmp due to wrong RHS of the predicate
define i32 @scmp_ne_0(i32 %0) {
; CHECK-LABEL: define i32 @scmp_ne_0(
; CHECK-SAME: i32 [[TMP0:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[TMP0]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = zext i1 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = icmp sgt i32 [[TMP0]], 1
; CHECK-NEXT:    [[TMP5:%.*]] = select i1 [[TMP4]], i32 [[TMP3]], i32 -1
; CHECK-NEXT:    ret i32 [[TMP5]]
;
  %2 = icmp ne i32 %0, 0
  %3 = zext i1 %2 to i32
  %4 = icmp sgt i32 %0, 1
  %5 = select i1 %4, i32 %3, i32 -1
  ret i32 %5
}

; y = 0 with unsigned compare but RHS wraps
define i32 @ucmp_x_0_inverted(i32 %x) {
; CHECK-LABEL: define i32 @ucmp_x_0_inverted(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    ret i32 -1
;
  %1 = icmp ne i32 %x, 0
  %2 = zext i1 %1 to i32
  %3 = icmp ugt i32 %x, -1
  %4 = select i1 %3, i32 %2, i32 -1
  ret i32 %4
}

; Don't fold with INT32_MIN
define i32 @scmp_x_0_inverted_const_min(i32 %x) {
; CHECK-LABEL: define i32 @scmp_x_0_inverted_const_min(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i32 [[X]], -2147483648
; CHECK-NEXT:    [[TMP2:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[TMP2]]
;
  %1 = icmp ne i32 %x, -2147483648
  %2 = zext i1 %1 to i32
  %3 = icmp sge i32 %x, -2147483648
  %4 = select i1 %3, i32 %2, i32 -1
  ret i32 %4
}

; Unsigned cmp of zext of i32 with i64 -1 should always be -1
define i32 @ucmp_x_0_inverted_i64_ugt(i32 %x) {
; CHECK-LABEL: define i32 @ucmp_x_0_inverted_i64_ugt(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    ret i32 -1
;
  %x64 = zext i32 %x to i64
  %cmp1 = icmp ugt i64 %x64, 0
  %zext = zext i1 %cmp1 to i64
  %cmp2 = icmp ugt i64 %x64, -1
  %sel = select i1 %cmp2, i64 %zext, i64 -1
  %ret = trunc i64 %sel to i32
  ret i32 %ret
}

; y = 4294967295 (UINT32_MAX), simply sign extend neq
define i32 @ucmp_x_const_u32max(i32 %x) {
; CHECK-LABEL: define i32 @ucmp_x_const_u32max(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i32 [[X]], -1
; CHECK-NEXT:    [[TMP2:%.*]] = sext i1 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[TMP2]]
;
  %1 = icmp ugt i32 %x, 4294967295
  %2 = zext i1 %1 to i32
  %3 = icmp ugt i32 %x, 4294967294
  %4 = select i1 %3, i32 %2, i32 -1
  ret i32 %4
}

; Don't fold with different signedness
define i32 @different_signedness_neg(i32 %x) {
; CHECK-LABEL: define i32 @different_signedness_neg(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ugt i32 [[X]], -10
; CHECK-NEXT:    [[TMP2:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = icmp sgt i32 [[X]], -11
; CHECK-NEXT:    [[TMP4:%.*]] = select i1 [[TMP3]], i32 [[TMP2]], i32 -1
; CHECK-NEXT:    ret i32 [[TMP4]]
;
  %1 = icmp ugt i32 %x, -10
  %2 = zext i1 %1 to i32
  %3 = icmp sgt i32 %x, -11
  %4 = select i1 %3, i32 %2, i32 -1
  ret i32 %4
}

; Test with wrong false value
define <4 x i32> @scmp_x_0_inverted_vec(<4 x i32> %x) {
; CHECK-LABEL: define <4 x i32> @scmp_x_0_inverted_vec(
; CHECK-SAME: <4 x i32> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne <4 x i32> [[X]], zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = zext <4 x i1> [[TMP1]] to <4 x i32>
; CHECK-NEXT:    [[TMP3:%.*]] = icmp sgt <4 x i32> [[X]], splat (i32 -1)
; CHECK-NEXT:    [[TMP4:%.*]] = select <4 x i1> [[TMP3]], <4 x i32> [[TMP2]], <4 x i32> <i32 -1, i32 -2, i32 -1, i32 -1>
; CHECK-NEXT:    ret <4 x i32> [[TMP4]]
;
  %2 = icmp ne <4 x i32> %x, zeroinitializer
  %3 = zext <4 x i1> %2 to <4 x i32>
  %4 = icmp sgt <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %5 = select <4 x i1> %4, <4 x i32> %3, <4 x i32> <i32 -1, i32 -2, i32 -1, i32 -1>
  ret <4 x i32> %5
}
