; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=loop-vectorize -S %s | FileCheck %s

target triple = "i386-unknow-linux"

define void @icmp_predicate_and_branch_cost(i32 %size, ptr %dst, i64 %conv5.i) #0 {
; CHECK-LABEL: @icmp_predicate_and_branch_cost(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[EXT_IV:%.*]] = zext i32 [[IV]] to i64
; CHECK-NEXT:    [[ADD_IV:%.*]] = add i64 [[EXT_IV]], 8
; CHECK-NEXT:    [[C_1:%.*]] = icmp ugt i64 [[ADD_IV]], [[CONV5_I:%.*]]
; CHECK-NEXT:    br i1 [[C_1]], label [[THEN_1:%.*]], label [[LOOP_LATCH]]
; CHECK:       then.1:
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult i32 [[IV]], [[SIZE:%.*]]
; CHECK-NEXT:    br i1 [[C_2]], label [[THEN_2:%.*]], label [[LOOP_LATCH]]
; CHECK:       then.2:
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[SIZE]], [[IV]]
; CHECK-NEXT:    [[TRUNC_OR:%.*]] = trunc i32 [[OR]] to i8
; CHECK-NEXT:    br label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[SINK:%.*]] = phi i8 [ [[TRUNC_OR]], [[THEN_2]] ], [ 1, [[LOOP_HEADER]] ], [ 0, [[THEN_1]] ]
; CHECK-NEXT:    store i8 [[SINK]], ptr [[DST:%.*]], align 1
; CHECK-NEXT:    [[IV_NEXT]] = trunc i64 [[ADD_IV]] to i32
; CHECK-NEXT:    [[C_3:%.*]] = icmp ugt i32 [[SIZE]], [[IV]]
; CHECK-NEXT:    br i1 [[C_3]], label [[LOOP_HEADER]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %ext.iv = zext i32 %iv to i64
  %add.iv = add i64 %ext.iv, 8
  %c.1 = icmp ugt i64 %add.iv, %conv5.i
  br i1 %c.1, label %then.1, label %loop.latch

then.1:
  %c.2 = icmp ult i32 %iv, %size
  br i1 %c.2, label %then.2, label %loop.latch

then.2:
  %or = or i32 %size, %iv
  %trunc.or = trunc i32 %or to i8
  br label %loop.latch

loop.latch:
  %sink = phi i8 [ %trunc.or, %then.2 ], [ 1, %loop.header ], [ 0, %then.1 ]
  store i8 %sink, ptr %dst, align 1
  %iv.next = trunc i64 %add.iv to i32
  %c.3 = icmp ugt i32 %size, %iv
  br i1 %c.3, label %loop.header, label %exit

exit:
  ret void
}

attributes #0 = { mustprogress "target-cpu"="pentium4" }
