; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -verify-machineinstrs %s -o - | FileCheck -check-prefixes=GCN %s

define half @test_s16(half %a) #0 {
; GCN-LABEL: test_s16:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_f16_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %fcmp = fcmp olt half %a, 0.0
  %sel = select i1 %fcmp, half 0.0, half %a
  ret half %sel
}

define float @test_s32(float %a) #0 {
; GCN-LABEL: test_s32:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_f32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %fcmp = fcmp olt float %a, 0.0
  %sel = select i1 %fcmp, float 0.0, float %a
  ret float %sel
}

define double @test_s64(double %a) #0 {
; GCN-LABEL: test_s64:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_f64_e32 vcc, 0, v[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %fcmp = fcmp olt double %a, 0.0
  %sel = select i1 %fcmp, double 0.0, double %a
  ret double %sel
}

define <4 x half> @test_v4s16(<4 x half> %a) #0 {
; GCN-LABEL: test_v4s16:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v4, 0
; GCN-NEXT:    v_cmp_gt_f16_e32 vcc, 0, v0
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GCN-NEXT:    v_cndmask_b32_e64 v5, v0, 0, vcc
; GCN-NEXT:    v_cmp_lt_f16_sdwa s[4:5], v0, v4 src0_sel:WORD_1 src1_sel:DWORD
; GCN-NEXT:    v_cmp_gt_f16_e32 vcc, 0, v1
; GCN-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v2, 0, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v2, v1, 0, vcc
; GCN-NEXT:    v_cmp_lt_f16_sdwa s[4:5], v1, v4 src0_sel:WORD_1 src1_sel:DWORD
; GCN-NEXT:    v_cndmask_b32_e64 v1, v3, 0, s[4:5]
; GCN-NEXT:    v_and_b32_e32 v3, 0xffff, v5
; GCN-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GCN-NEXT:    v_lshl_or_b32 v0, v0, 16, v3
; GCN-NEXT:    v_lshl_or_b32 v1, v1, 16, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %fcmp = fcmp olt <4 x half> %a, zeroinitializer
  %sel = select <4 x i1> %fcmp, <4 x half> zeroinitializer, <4 x half> %a
  ret <4 x half> %sel
}

define <8 x half> @test_v8s16(<8 x half> %a) #0 {
; GCN-LABEL: test_v8s16:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    v_cmp_gt_f16_e32 vcc, 0, v0
; GCN-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GCN-NEXT:    v_cndmask_b32_e64 v9, v0, 0, vcc
; GCN-NEXT:    v_cmp_lt_f16_sdwa s[4:5], v0, v8 src0_sel:WORD_1 src1_sel:DWORD
; GCN-NEXT:    v_cmp_gt_f16_e32 vcc, 0, v1
; GCN-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v4, 0, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v4, v1, 0, vcc
; GCN-NEXT:    v_cmp_lt_f16_sdwa s[4:5], v1, v8 src0_sel:WORD_1 src1_sel:DWORD
; GCN-NEXT:    v_cmp_gt_f16_e32 vcc, 0, v2
; GCN-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GCN-NEXT:    v_cndmask_b32_e64 v1, v5, 0, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v5, v2, 0, vcc
; GCN-NEXT:    v_cmp_lt_f16_sdwa s[4:5], v2, v8 src0_sel:WORD_1 src1_sel:DWORD
; GCN-NEXT:    v_cmp_gt_f16_e32 vcc, 0, v3
; GCN-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GCN-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GCN-NEXT:    v_cndmask_b32_e64 v2, v6, 0, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v6, v3, 0, vcc
; GCN-NEXT:    v_cmp_lt_f16_sdwa s[4:5], v3, v8 src0_sel:WORD_1 src1_sel:DWORD
; GCN-NEXT:    v_lshl_or_b32 v1, v1, 16, v4
; GCN-NEXT:    v_and_b32_e32 v4, 0xffff, v5
; GCN-NEXT:    v_cndmask_b32_e64 v3, v7, 0, s[4:5]
; GCN-NEXT:    v_and_b32_e32 v7, 0xffff, v9
; GCN-NEXT:    v_lshl_or_b32 v2, v2, 16, v4
; GCN-NEXT:    v_and_b32_e32 v4, 0xffff, v6
; GCN-NEXT:    v_lshl_or_b32 v0, v0, 16, v7
; GCN-NEXT:    v_lshl_or_b32 v3, v3, 16, v4
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %fcmp = fcmp olt <8 x half> %a, zeroinitializer
  %sel = select <8 x i1> %fcmp, <8 x half> zeroinitializer, <8 x half> %a
  ret <8 x half> %sel
}

define <2 x float> @test_v2s32(<2 x float> %a) #0 {
; GCN-LABEL: test_v2s32:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_f32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cmp_gt_f32_e32 vcc, 0, v1
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %fcmp = fcmp olt <2 x float> %a, zeroinitializer
  %sel = select <2 x i1> %fcmp, <2 x float> zeroinitializer, <2 x float> %a
  ret <2 x float> %sel
}

define <4 x float> @test_v4s32(<4 x float> %a) #0 {
; GCN-LABEL: test_v4s32:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_f32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cmp_gt_f32_e32 vcc, 0, v1
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, 0, vcc
; GCN-NEXT:    v_cmp_gt_f32_e32 vcc, 0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v2, v2, 0, vcc
; GCN-NEXT:    v_cmp_gt_f32_e32 vcc, 0, v3
; GCN-NEXT:    v_cndmask_b32_e64 v3, v3, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %fcmp = fcmp olt <4 x float> %a, zeroinitializer
  %sel = select <4 x i1> %fcmp, <4 x float> zeroinitializer, <4 x float> %a
  ret <4 x float> %sel
}

define <2 x double> @test_v2s64(<2 x double> %a) #0 {
; GCN-LABEL: test_v2s64:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_f64_e32 vcc, 0, v[0:1]
; GCN-NEXT:    v_cmp_gt_f64_e64 s[4:5], 0, v[2:3]
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v2, v2, 0, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v3, v3, 0, s[4:5]
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %fcmp = fcmp olt <2 x double> %a, zeroinitializer
  %sel = select <2 x i1> %fcmp, <2 x double> zeroinitializer, <2 x double> %a
  ret <2 x double> %sel
}

