/* amd64-linux.elf-fold.h
   created from amd64-linux.elf-fold.bin, 21238 (0x52f6) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_AMD64_LINUX_ELF_FOLD_SIZE    21238
#define STUB_AMD64_LINUX_ELF_FOLD_ADLER32 0xb11c41e0
#define STUB_AMD64_LINUX_ELF_FOLD_CRC32   0x3c89e03a

unsigned char stub_amd64_linux_elf_fold[21238] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0, 24, 37,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 26,  0, 23,  0,
/* 0x0040 */   0,240,255,255,255,255,255,255,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0050 */ 243, 15, 30,250, 76,137,109, 48, 76,137,232,131,224,  1,  9, 69,
/* 0x0060 */  16, 72,137,230,246, 69, 48,  2,117,  7, 72,129,236,  0, 16,  0,
/* 0x0070 */   0, 72,137,231,106,  8, 89,243, 72,165, 72,131, 62,  0, 72,165,
/* 0x0080 */ 117,248, 73,137,254,246, 69, 48,  2,117,  2, 72,171, 72,131, 62,
/* 0x0090 */   0, 72,165,117,248, 73,137,252, 72,137,249, 72,131, 62,  0, 72,
/* 0x00a0 */ 165, 72,165,117,246, 73,137,255, 73,137,245, 73, 41,252,246, 69,
/* 0x00b0 */  48,  2,116,  8,131,205,255, 73,137,254,235,114, 87, 72,141, 61,
/* 0x00c0 */   0,  0,  0,  0, 41,246,232,  0,  0,  0,  0,137,197, 94,186,255,
/* 0x00d0 */  15,  0,  0,106, 89, 88, 15,  5,133,192,121,  5, 87, 94,106, 15,
/* 0x00e0 */  88,145,253, 73,141,125,255,176,  0,170, 72,141,116, 14,255,243,
/* 0x00f0 */ 164, 72,131,239,  3,199,  7, 32, 32, 32, 61, 73,137, 62, 72,131,
/* 0x0100 */ 231,248, 76,137,249, 72, 41,225, 72,131,239,  8, 73,141,119,248,
/* 0x0110 */ 137,248, 49,240,131,224,  8, 72, 41,199, 73,137,254, 72,193,233,
/* 0x0120 */   3,243, 72,165, 72,141,103,  8,252, 75,141, 76, 38,  8, 95, 94,
/* 0x0130 */  72,131,231,252, 65, 88, 68,137,192,131,224,  1, 72,  9,193, 73,
/* 0x0140 */  41,192, 77,137,197, 72,129,236,  0,  8,  0,  0, 72,137,226,232,
/* 0x0150 */   0,  0,  0,  0, 72,129,196,  0,  8,  0,  0,137,235, 72,137, 68,
/* 0x0160 */  36, 24,255, 21,224,254,255,255, 73,139,181,160,  0,  0,  0, 76,
/* 0x0170 */ 137,239,232,  0,  0,  0,  0,133,219,120, 31, 77, 41,201, 65,137,
/* 0x0180 */ 216,106,  2, 89,106,  1, 90,190,  0, 16,  0,  0, 41,255,232,  0,
/* 0x0190 */   0,  0,  0,137,223,232,  0,  0,  0,  0, 95, 94,106, 11, 88, 62,
/* 0x01a0 */  65,255, 38, 72,139,  5,150,254,255,255,195,  0, 81, 72, 57, 23,
/* 0x01b0 */  76,139, 71,  8, 72,141, 74,255,115, 10,191,127,  0,  0,  0,232,
/* 0x01c0 */   0,  0,  0,  0, 72,131,249,255,116, 17, 65, 15,182,  0, 72,255,
/* 0x01d0 */ 201, 73,255,192,136,  6, 72,255,198,235,233, 72,  1, 87,  8, 72,
/* 0x01e0 */  41, 23, 88,195, 85, 72,137,245, 83, 72,137,251, 72,131,236, 40,
/* 0x01f0 */  72,131, 62,  0, 15,132,176,  0,  0,  0, 72,141,116, 36, 16,186,
/* 0x0200 */  12,  0,  0,  0, 72,137,223,232,160,255,255,255,139, 68, 36, 16,
/* 0x0210 */ 139, 84, 36, 20,133,192,117, 20,129,250, 85, 80, 88, 33,117, 16,
/* 0x0220 */  72,131, 59,  0, 15,132,128,  0,  0,  0,235,  4,133,210,117, 10,
/* 0x0230 */ 191,127,  0,  0,  0,232,  0,  0,  0,  0, 57,194,119,242,137,193,
/* 0x0240 */  72, 59, 77,  0,119,234, 57,194, 72,139,117,  8,115, 51, 72,139,
/* 0x0250 */ 123,  8, 72,141, 84, 36,  8, 72,137, 76, 36,  8, 72,131,239, 12,
/* 0x0260 */ 232,  0,  0,  0,  0,133,192,117,199,139, 68, 36, 16, 72, 57, 68,
/* 0x0270 */  36,  8,117,188,139, 68, 36, 20, 72,  1, 67,  8, 72, 41,  3,235,
/* 0x0280 */  14, 72,131,  3, 12,137,210, 72,137,223,232, 29,255,255,255,139,
/* 0x0290 */  84, 36, 16, 72,139, 69,  0, 72,  1, 85,  8, 72, 41,208, 72,133,
/* 0x02a0 */ 192, 72,137, 69,  0,233, 74,255,255,255, 72,131,196, 40, 91, 93,
/* 0x02b0 */ 195, 49,192, 72,133,255, 65, 80,116, 12, 69, 49,192, 69, 49,201,
/* 0x02c0 */  64,246,199,  1,116, 16, 49,192,235, 77, 76,137,192, 77,137, 16,
/* 0x02d0 */  73,137, 80,  8,235, 65, 72,139, 15, 65,137,242, 76, 57,209,117,
/* 0x02e0 */  12, 72,137,248, 65,255,193, 72,137, 87,  8,235, 11, 72,131,249,
/* 0x02f0 */   1,117,  5, 73,137,248,235, 25, 72,133,201,117, 20, 69,133,201,
/* 0x0300 */ 117, 21, 77,133,192,117,195,191,127,  0,  0,  0,232,  0,  0,  0,
/* 0x0310 */   0, 72,131,199, 16,235,191, 94,195, 65, 84, 65,137,248, 73,137,
/* 0x0320 */ 244,252, 83,137,211, 69, 49,201, 72,137,217,186,  3,  0,  0,  0,
/* 0x0330 */  72,129,236,  8, 16,  0,  0, 72,137,231,243,164, 68,137,198, 76,
/* 0x0340 */ 137,231, 65,131,200,255,177, 50,232,  0,  0,  0,  0, 72,137,230,
/* 0x0350 */  76,137,231, 72,137,217,252,243,164, 72,129,196,  8, 16,  0,  0,
/* 0x0360 */  91, 65, 92,195, 65, 87, 65,137,255, 65, 86, 73,131,206,255, 65,
/* 0x0370 */  85, 65, 84, 69, 49,228, 85,137,213, 83, 72,137,243, 72,131,236,
/* 0x0380 */  24, 72,137, 76, 36, 16, 72,199, 68, 36,  8,  0, 16,  0,  0,232,
/* 0x0390 */   0,  0,  0,  0, 72,137,193,255,205,120, 62,131, 59,  1,117, 51,
/* 0x03a0 */  72,139, 83, 40, 72,133,210,116, 42, 72,139, 67, 16, 76, 57,240,
/* 0x03b0 */  76, 15, 66,240, 72,141,  4,  2, 73, 57,196, 76, 15, 66,224, 72,
/* 0x03c0 */ 139, 67, 48, 72, 57, 68, 36,  8, 72, 15, 67, 68, 36,  8, 72,137,
/* 0x03d0 */  68, 36,  8, 72,131,195, 56,235,190, 73, 33,206, 72,137,202, 73,
/* 0x03e0 */ 137,205, 72,247,218, 77, 41,244,189,  1,  0,  0,  0, 73,141, 68,
/* 0x03f0 */  20,255, 73, 33,197, 72, 59, 84, 36,  8,115, 15,  1,237,137,232,
/* 0x0400 */  72, 15,175,194, 72, 59, 68, 36,  8,235,239,255,205, 65,131,207,
/* 0x0410 */  34, 69, 49,201,137,232, 65,131,200,255, 68,137,249, 15,175,194,
/* 0x0420 */  76,137,247, 49,210, 70,141, 36, 40, 68,137,230,232,  0,  0,  0,
/* 0x0430 */   0,133,237, 72,137,195,116, 53, 72,139, 84, 36,  8, 72,247,216,
/* 0x0440 */  72,255,202, 72,137,213, 72, 33,197,116, 17, 72,137,223, 72,137,
/* 0x0450 */ 238, 72,  1,235, 65, 41,236,232,  0,  0,  0,  0, 69, 41,236,116,
/* 0x0460 */  12, 74,141, 60, 43, 68,137,230,232,  0,  0,  0,  0, 72,139, 84,
/* 0x0470 */  36, 16, 73,141, 68, 29,  0, 76, 41,243, 72,137,  2, 72,131,196,
/* 0x0480 */  24, 72,137,216, 91, 93, 65, 92, 65, 93, 65, 94, 65, 95,195, 65,
/* 0x0490 */  87, 76,137,192, 65, 86, 65, 85, 73,137,253, 65, 84, 85, 83, 49,
/* 0x04a0 */ 219, 72,131,236,120, 76,  3,111, 32, 72,133,246, 72,137, 76, 36,
/* 0x04b0 */  40, 72,137,124, 36, 64, 72,137,116, 36, 56,137, 84, 36, 52, 72,
/* 0x04c0 */ 199, 68, 36, 32,  0,  0,  0,  0, 72,199, 68, 36, 72,  0,  0,  0,
/* 0x04d0 */   0, 15,183, 79, 16,116, 72,102,131,249,  3, 73,141, 80, 64,117,
/* 0x04e0 */  25, 72,  3, 66, 16, 76,137,193, 72, 43, 74, 72, 72,  3, 66, 40,
/* 0x04f0 */  72,137, 76, 36, 32, 72,137, 68, 36, 72, 72,139,124, 36, 32, 72,
/* 0x0500 */   3,122, 16, 69, 49,201, 72,139,114, 40, 65,131,200,255,185, 50,
/* 0x0510 */   0,  0,  0,186,  3,  0,  0,  0,232,  0,  0,  0,  0,235, 44, 72,
/* 0x0520 */ 139, 68, 36, 64,102,131,249,  3,191, 16,  0,  0,  0, 72,141, 76,
/* 0x0530 */  36, 72, 76,137,238, 15,183, 80, 56,184,  0,  0,  0,  0, 15, 68,
/* 0x0540 */ 248,232,  0,  0,  0,  0, 72,137, 68, 36, 32,232,  0,  0,  0,  0,
/* 0x0550 */  72,139, 84, 36, 64, 72,137, 68, 36, 24,199, 68, 36, 20,  0,  0,
/* 0x0560 */   0,  0,102,131,122, 56,  0, 15,132,114,  3,  0,  0, 72,131,124,
/* 0x0570 */  36, 56,  0,116, 36, 65,131,125,  0,  6,117, 29, 72,139, 84, 36,
/* 0x0580 */  32, 73,  3, 85, 16,190,  3,  0,  0,  0, 72,139,124, 36, 40,232,
/* 0x0590 */  29,253,255,255,233, 43,  3,  0,  0, 65,131,125,  0,  1, 15,133,
/* 0x05a0 */  32,  3,  0,  0, 73,131,125, 40,  0, 15,132, 21,  3,  0,  0, 65,
/* 0x05b0 */ 139, 77,  4,199, 68, 36, 16, 64, 98, 81,115,131,225,  7,193,225,
/* 0x05c0 */   2,211,108, 36, 16,131,100, 36, 16,  7, 72,131,124, 36, 56,  0,
/* 0x05d0 */ 116, 90, 73,131,125,  8,  0,117, 83, 72,139, 76, 36, 64, 72,139,
/* 0x05e0 */  84, 36, 32,190,  3,  0,  0,  0, 73,  3, 85, 16, 72,139,124, 36,
/* 0x05f0 */  40, 72,  3, 81, 32,232,183,252,255,255, 72,139, 68, 36, 64, 72,
/* 0x0600 */ 139,124, 36, 40,190,  5,  0,  0,  0, 72, 15,183, 80, 56,232,158,
/* 0x0610 */ 252,255,255, 72,139, 76, 36, 64, 72,139,124, 36, 40,190,  4,  0,
/* 0x0620 */   0,  0, 72, 15,183, 81, 54,232,133,252,255,255, 72,139,124, 36,
/* 0x0630 */  32, 73,  3,125, 16, 73,139, 69, 40, 73,139,117, 32,199, 68, 36,
/* 0x0640 */   4,  0,  0,  0,  0, 72,  1,248, 73,137,246, 73,137,252, 72,137,
/* 0x0650 */  68, 36,  8, 72,139, 68, 36, 24, 76,141, 60, 55, 72,137,116, 36,
/* 0x0660 */  96, 72,137,124, 36,104, 72,247,208, 72, 33,248, 73,  1,198, 73,
/* 0x0670 */  41,196, 72,131,124, 36, 56,  0,116,109, 65,246, 69,  4,  1,116,
/* 0x0680 */  51,190, 16,  0,  0,  0, 72,141, 61,  0,  0,  0,  0,232,  0,  0,
/* 0x0690 */   0,  0, 76,137,246,137,199,137, 68, 36,  4,232,  0,  0,  0,  0,
/* 0x06a0 */  68,139, 68, 36,  4, 69, 49,201,185, 17,  0,  0,  0,186,  3,  0,
/* 0x06b0 */   0,  0,235, 30, 72,131,124, 36, 56,  0,116, 43,139, 84, 36, 16,
/* 0x06c0 */  69, 49,201, 65,131,200,255,185, 50,  0,  0,  0,131,202,  2,131,
/* 0x06d0 */ 226,251, 76,137,246, 76,137,231,232,  0,  0,  0,  0, 73, 57,196,
/* 0x06e0 */ 116, 48,233,165,  1,  0,  0, 77,139, 77,  8, 68,139, 68, 36, 52,
/* 0x06f0 */ 185, 18,  0,  0,  0,139, 84, 36, 16, 76,137,246, 76,137,231, 73,
/* 0x0700 */  41,193,232,  0,  0,  0,  0, 73, 57,196, 15,133,124,  1,  0,  0,
/* 0x0710 */ 235, 23, 72,131,124, 36, 56,  0,116, 15, 72,139,124, 36, 56, 72,
/* 0x0720 */ 141,116, 36, 96,232,187,250,255,255,246, 68, 36, 16,  2,116, 24,
/* 0x0730 */ 139, 68, 36, 24, 68,137,249, 76,137,255,247,217,252,247,208, 33,
/* 0x0740 */ 193, 49,192,243,170, 73,137,255, 72,131,124, 36, 56,  0, 15,132,
/* 0x0750 */  30,  1,  0,  0, 65,246, 69,  4,  1, 15,132, 19,  1,  0,  0, 72,
/* 0x0760 */ 133,219, 15,133,195,  0,  0,  0,199, 68, 36, 80,243, 15, 30,250,
/* 0x0770 */ 199, 68, 36, 84, 15,  5, 90, 88, 72,184,255,255,255,255,  1,  0,
/* 0x0780 */   0,  0,199, 68, 36, 88, 62,255,224,144, 73, 35, 69,  0, 72,186,
/* 0x0790 */   1,  0,  0,  0,  1,  0,  0,  0,139, 76, 36, 24, 72,139,108, 36,
/* 0x07a0 */ 104, 72, 57,208,247,209,117,108,137,232,247,216, 33,193,131,249,
/* 0x07b0 */  11,118, 23,199, 69,  0,243, 15, 30,250,139, 68, 36, 84,137, 69,
/* 0x07c0 */   4,139, 68, 36, 88,137, 69,  8,235, 74,190, 16,  0,  0,  0, 72,
/* 0x07d0 */ 141, 61,  0,  0,  0,  0,232,  0,  0,  0,  0, 72,141,116, 36, 80,
/* 0x07e0 */ 137,195,186, 12,  0,  0,  0,137,199,232,  0,  0,  0,  0, 49,255,
/* 0x07f0 */  69, 49,201, 65,137,216,185,  1,  0,  0,  0,186,  5,  0,  0,  0,
/* 0x0800 */ 190, 12,  0,  0,  0,232,  0,  0,  0,  0,137,223, 72,137,197,232,
/* 0x0810 */   0,  0,  0,  0, 72,133,237, 72,137,235,116, 15, 72,139,124, 36,
/* 0x0820 */  40, 72,137,234, 49,246,232,134,250,255,255,186,  4,  0,  0,  0,
/* 0x0830 */  76,137,246, 76,137,231,232,  0,  0,  0,  0, 76,137,246, 76,137,
/* 0x0840 */ 231,232,  0,  0,  0,  0, 68,139, 68, 36,  4,139, 84, 36, 16, 69,
/* 0x0850 */  49,201,185, 17,  0,  0,  0, 76,137,246, 76,137,231,232,  0,  0,
/* 0x0860 */   0,  0, 73, 57,196,117, 37,139,124, 36,  4,232,  0,  0,  0,  0,
/* 0x0870 */ 235, 36,131,124, 36, 16,  3,116, 29,139, 84, 36, 16, 76,137,246,
/* 0x0880 */  76,137,231,232,  0,  0,  0,  0,133,192,116, 10,191,127,  0,  0,
/* 0x0890 */   0,232,  0,  0,  0,  0, 76, 59,124, 36,  8,115, 39, 76, 41,124,
/* 0x08a0 */  36,  8,139, 84, 36, 16, 69, 49,201, 72,139,116, 36,  8, 65,131,
/* 0x08b0 */ 200,255,185, 50,  0,  0,  0, 76,137,255,232,  0,  0,  0,  0, 73,
/* 0x08c0 */  57,199,117,200, 72,139, 84, 36, 64,255, 68, 36, 20, 73,131,197,
/* 0x08d0 */  56, 15,183, 66, 56, 57, 68, 36, 20, 15,140,142,252,255,255, 72,
/* 0x08e0 */ 131,124, 36, 56,  0,116, 10, 72,139,124, 36, 72,232,  0,  0,  0,
/* 0x08f0 */   0, 72,139, 68, 36, 32, 72,131,196,120, 91, 93, 65, 92, 65, 93,
/* 0x0900 */  65, 94, 65, 95,195, 65, 86, 73,137,206, 65, 85, 65, 84, 73,137,
/* 0x0910 */ 212, 85, 73,141,108, 36, 64, 83, 76,137,195, 72,131,236, 48,139,
/* 0x0920 */   7, 72,137,116, 36, 16, 72,141,116, 36, 32, 72,137,124, 36,  8,
/* 0x0930 */  72,137,124, 36, 24, 72,137, 84, 36, 40, 72,137, 68, 36, 32,139,
/* 0x0940 */  71,  4, 72,137,231, 72,131,192, 12, 72,137,  4, 36,232,146,248,
/* 0x0950 */ 255,255, 72,139,147,144,  0,  0,  0, 49,246, 76,137,247,232, 78,
/* 0x0960 */ 249,255,255, 72,137, 88,  8,232,  0,  0,  0,  0, 72,141,116, 36,
/* 0x0970 */  16, 73,137,216, 76,137,241, 49,210, 76,137,231,232, 14,251,255,
/* 0x0980 */ 255, 73,137,197, 77,  3,108, 36, 24,190,  9,  0,  0,  0, 76,137,
/* 0x0990 */ 247, 72,137,195, 76,137,234,232, 21,249,255,255, 65, 15,183, 76,
/* 0x09a0 */  36, 56, 49,210,102,133,201,116,123,131,125,  0,  3,117,104, 72,
/* 0x09b0 */   3, 93, 16, 49,210, 49,246, 72,137,223,232,  0,  0,  0,  0,133,
/* 0x09c0 */ 192,137,197,120, 23,186,  0,  4,  0,  0, 76,137,230,137,199,232,
/* 0x09d0 */   0,  0,  0,  0, 72, 61,  0,  4,  0,  0,116, 10,191,127,  0,  0,
/* 0x09e0 */   0,232,  0,  0,  0,  0, 69, 49,192, 49,201,137,234, 49,246, 76,
/* 0x09f0 */ 137,231,232,152,250,255,255, 73,137,197, 76,  3,104, 24, 76,137,
/* 0x0a00 */ 247, 72,137,194,190,  7,  0,  0,  0,232,163,248,255,255,137,239,
/* 0x0a10 */ 232,  0,  0,  0,  0,235, 13,255,194, 15,183,193, 72,131,197, 56,
/* 0x0a20 */  57,194,114,133, 72,131,196, 48, 76,137,232, 91, 93, 65, 92, 65,
/* 0x0a30 */  93, 65, 94,195, 72,137, 92, 36,224, 72,137,108, 36,232, 76,137,
/* 0x0a40 */ 100, 36,240, 76,137,108, 36,248, 72,131,236, 40, 73,137,252, 65,
/* 0x0a50 */ 137,245, 72,141, 45,  0,  0,  0,  0,190, 16,  0,  0,  0, 72,137,
/* 0x0a60 */ 239,232,  0,  0,  0,  0,137,195,131,248,234,117, 15,190,  0,  0,
/* 0x0a70 */   0,  0, 72,137,239,232,  0,  0,  0,  0,137,195,133,219,121, 68,
/* 0x0a80 */  72,141, 61,  0,  0,  0,  0,186,192,  1,  0,  0,190,  2,  0, 65,
/* 0x0a90 */   0,232,  0,  0,  0,  0,137,195,133,192,121, 40, 72, 99,208,131,
/* 0x0aa0 */ 248,235,117,109, 72,141, 53,  0,  0,  0,  0,186, 61,  0,  0,  0,
/* 0x0ab0 */ 191,  2,  0,  0,  0,232,  0,  0,  0,  0,191,127,  0,  0,  0,232,
/* 0x0ac0 */   0,  0,  0,  0, 68,137,238,137,223,232,  0,  0,  0,  0, 72, 99,
/* 0x0ad0 */ 208,133,192,120, 60, 73,131,252,  1, 25,201,131,225,240,131,193,
/* 0x0ae0 */  17, 68,137,238, 65,185,  0,  0,  0,  0, 65,137,216,186,  3,  0,
/* 0x0af0 */   0,  0, 76,137,231,232,  0,  0,  0,  0, 73,137,196,232,  0,  0,
/* 0x0b00 */   0,  0, 76,137,226, 73, 57,196,115,  7,141, 67,  1, 74,141, 20,
/* 0x0b10 */  32, 72,137,208, 72,139, 92, 36,  8, 72,139,108, 36, 16, 76,139,
/* 0x0b20 */ 100, 36, 24, 76,139,108, 36, 32, 72,131,196, 40,195,204,195, 47,
/* 0x0b30 */ 112,114,111, 99, 47,115,101,108,102, 47,101,120,101,  0,184, 63,
/* 0x0b40 */   1,  0,  0, 15,  5,133,192,121, 45,133,246,116,  4, 49,246,235,
/* 0x0b50 */ 237,232, 17,  0,  0,  0,192,  1,  0,  0,  2,  0, 65,  0, 47,100,
/* 0x0b60 */ 101,118, 47,115,104,109,  0, 94,173,146,173, 86,150, 95,106,  2,
/* 0x0b70 */  88,232, 26,  0,  0,  0,195, 72,139,  5,  0,  0,  0,  0,247,208,
/* 0x0b80 */  33,248, 72, 41,199, 72,  1,198,176,  9, 73,137,202, 15,182,192,
/* 0x0b90 */  80, 15,  5, 89, 72, 61,  0,240,255,255,114,  6,131,249,  2,116,
/* 0x0ba0 */   1,204,195,139,  5,  0,  0,  0,  0,247,208,176, 26,235, 52, 33,
/* 0x0bb0 */ 248, 72, 41,199, 72,  1,198,233,  0,  0,  0,  0,139,  5,  0,  0,
/* 0x0bc0 */   0,  0,247,208, 33,248, 72, 41,199, 72,  1,198,233,  0,  0,  0,
/* 0x0bd0 */   0,139,  5,  0,  0,  0,  0,247,208, 33,248, 72, 41,199, 72,  1,
/* 0x0be0 */ 198,176, 11,235,  2,176, 60,235,  2,176, 12,235,  2,176,  3,235,
/* 0x0bf0 */   2,176, 77,235,  2,176,  2,235,  2,176, 10,235,  2,176, 26,235,
/* 0x0c00 */   2,176,  1,235,  2,176,  0,235,132, 85, 72,137,229, 83, 82, 86,
/* 0x0c10 */  87,232,101,  0,  0,  0, 91, 95, 94, 80, 15,182, 75,  9,133,201,
/* 0x0c20 */ 116, 11, 15,182, 83, 10,139, 54,232,  4,  0,  0,  0, 88, 91, 93,
/* 0x0c30 */ 195,131,249, 73,117, 68, 83, 87, 72,141, 76, 55,253, 94, 86, 91,
/* 0x0c40 */ 235, 47, 72, 57,206,115, 50, 86, 94,172, 60,128,114, 10, 60,143,
/* 0x0c50 */ 119,  6,128,126,254, 15,116,  6, 44,232, 60,  1,119,228, 72, 57,
/* 0x0c60 */ 206,115, 22, 86,173, 40,208,117,223, 95, 15,200, 41,248,  1,216,
/* 0x0c70 */ 171, 72, 57,206,115,  3,172,235,223, 91,195, 82, 68, 15,182, 71,
/* 0x0c80 */   8, 87, 86, 95, 94,139, 70,  4, 72,131,198, 12, 72,  1,240, 80,
/* 0x0c90 */  87, 49,219, 49,201, 72,131,205,255,235, 86,139, 30, 72,131,238,
/* 0x0ca0 */ 252, 17,219, 15,182, 22,243,195,243, 15, 30,250,  1,219,116,235,
/* 0x0cb0 */ 243,195, 72,141,  4, 47,131,249,  5, 15,182, 16,118, 33,131,253,
/* 0x0cc0 */ 252,119, 28,131,233,  4,139, 16, 72,131,192,  4,131,233,  4,137,
/* 0x0cd0 */  23, 72,141,127,  4,115,239,131,193,  4, 15,182, 16,116, 16, 72,
/* 0x0ce0 */ 255,192,136, 23,255,201, 15,182, 16, 72,141,127,  1,117,240,243,
/* 0x0cf0 */ 195,252, 65,131,248,  8, 15,133,222,  0,  0,  0,235,  8, 72,255,
/* 0x0d00 */ 198,136, 23, 72,255,199, 15,182, 22,  1,219,117, 11,139, 30, 72,
/* 0x0d10 */ 131,238,252, 17,219, 15,182, 22,114,228,141, 65,  1,235, 19,255,
/* 0x0d20 */ 200,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,
/* 0x0d30 */  17,192,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182,
/* 0x0d40 */  22, 17,192,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,
/* 0x0d50 */ 182, 22,115,203,131,232,  3,114, 26,193,224,  8, 72,255,198,  9,
/* 0x0d60 */ 208,131,240,255, 15,132,  0,  0,  0,  0,209,248, 72, 99,232,114,
/* 0x0d70 */  68,235, 14,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,114,
/* 0x0d80 */  52,255,193,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,114,
/* 0x0d90 */  36,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,
/* 0x0da0 */  17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,115,225,
/* 0x0db0 */ 131,193,  2,235, 17,  1,219,117, 11,139, 30, 72,131,238,252, 17,
/* 0x0dc0 */ 219, 15,182, 22, 17,201, 72,129,253,  0,251,255,255,131,209,  2,
/* 0x0dd0 */ 232,  0,  0,  0,  0,233, 44,255,255,255, 65,131,248,  5, 15,133,
/* 0x0de0 */ 209,  0,  0,  0,235,  8, 72,255,198,136, 23, 72,255,199, 15,182,
/* 0x0df0 */  22,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,
/* 0x0e00 */ 114,228,141, 65,  1,235, 19,255,200,  1,219,117, 11,139, 30, 72,
/* 0x0e10 */ 131,238,252, 17,219, 15,182, 22, 17,192,  1,219,117, 11,139, 30,
/* 0x0e20 */  72,131,238,252, 17,219, 15,182, 22, 17,192,  1,219,117, 11,139,
/* 0x0e30 */  30, 72,131,238,252, 17,219, 15,182, 22,115,203,131,232,  3,114,
/* 0x0e40 */  24,193,224,  8, 72,255,198,  9,208,131,240,255, 15,132,  0,  0,
/* 0x0e50 */   0,  0,209,248, 72, 99,232,235, 15,  1,219,117, 11,139, 30, 72,
/* 0x0e60 */ 131,238,252, 17,219, 15,182, 22, 17,201,  1,219,117, 11,139, 30,
/* 0x0e70 */  72,131,238,252, 17,219, 15,182, 22, 17,201,117, 36,255,193,  1,
/* 0x0e80 */ 219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,201,
/* 0x0e90 */   1,219,117,  8,139, 30, 72,131,238,252, 17,219,115,225,131,193,
/* 0x0ea0 */   2, 72,129,253,  0,251,255,255,131,209,  1,232,  0,  0,  0,  0,
/* 0x0eb0 */ 233, 57,255,255,255, 65,131,248,  2, 15,133,186,  0,  0,  0,235,
/* 0x0ec0 */   8, 72,255,198,136, 23, 72,255,199, 15,182, 22,  1,219,117, 11,
/* 0x0ed0 */ 139, 30, 72,131,238,252, 17,219, 15,182, 22,114,228,141, 65,  1,
/* 0x0ee0 */   1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,
/* 0x0ef0 */ 192,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,
/* 0x0f00 */ 115,222,131,232,  3,114, 20,193,224,  8, 72,255,198,  9,208,131,
/* 0x0f10 */ 240,255, 15,132,  0,  0,  0,  0, 72, 99,232,141, 65,  1,  1,219,
/* 0x0f20 */ 117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,201,  1,
/* 0x0f30 */ 219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,201,
/* 0x0f40 */ 117, 36,137,193,131,192,  2,  1,219,117, 11,139, 30, 72,131,238,
/* 0x0f50 */ 252, 17,219, 15,182, 22, 17,201,  1,219,117,  8,139, 30, 72,131,
/* 0x0f60 */ 238,252, 17,219,115,225, 72,129,253,  0,243,255,255, 17,193,232,
/* 0x0f70 */   0,  0,  0,  0,233, 80,255,255,255, 65,131,248, 14, 15,133,  0,
/* 0x0f80 */   0,  0,  0, 87, 86,139,118,248, 72,137,209, 95, 90, 85, 72,137,
/* 0x0f90 */ 229, 68,139,  9, 73,137,208, 72,137,242, 72,141,119,  2, 86,138,
/* 0x0fa0 */   7,255,202,136,193, 36,  7,192,233,  3, 72,199,195,  0,253,255,
/* 0x0fb0 */ 255, 72,211,227,136,193, 72,141,156, 92,136,241,255,255, 72,131,
/* 0x0fc0 */ 227,192,106,  0, 72, 57,220,117,249, 83, 72,141,123,  8,138, 78,
/* 0x0fd0 */ 255,255,202,136, 71,  2,136,200,192,233,  4,136, 79,  1, 36, 15,
/* 0x0fe0 */ 136,  7, 72,141, 79,252,106, 90, 65, 87, 72,141, 71,  4, 69, 49,
/* 0x0ff0 */ 255, 65, 86, 65,190,  1,  0,  0,  0, 65, 85, 69, 49,237, 65, 84,
/* 0x1000 */  85, 83, 72,137, 76, 36,240, 72,137, 68, 36,216,184,  1,  0,  0,
/* 0x1010 */   0, 72,137,116, 36,248, 76,137, 68, 36,232,137,195, 68,137, 76,
/* 0x1020 */  36,228, 15,182, 79,  2,211,227,137,217, 72,139, 92, 36, 56,255,
/* 0x1030 */ 201,137, 76, 36,212, 15,182, 79,  1,211,224, 72,139, 76, 36,240,
/* 0x1040 */ 255,200,137, 68, 36,208, 15,182,  7,199,  1,  0,  0,  0,  0,199,
/* 0x1050 */  68, 36,200,  0,  0,  0,  0,199, 68, 36,196,  1,  0,  0,  0,199,
/* 0x1060 */  68, 36,192,  1,  0,  0,  0,199, 68, 36,188,  1,  0,  0,  0,199,
/* 0x1070 */   3,  0,  0,  0,  0,137, 68, 36,204, 15,182, 79,  1,  1,193,184,
/* 0x1080 */   0,  3,  0,  0,211,224, 49,201,141,184, 54,  7,  0,  0, 65, 57,
/* 0x1090 */ 255,115, 19, 72,139, 92, 36,216,137,200,255,193, 57,249,102,199,
/* 0x10a0 */   4, 67,  0,  4,235,235, 72,139,124, 36,248,137,208, 69, 49,210,
/* 0x10b0 */  65,131,203,255, 49,210, 73,137,252, 73,  1,196, 76, 57,231, 15,
/* 0x10c0 */ 132,239,  8,  0,  0, 15,182,  7, 65,193,226,  8,255,194, 72,255,
/* 0x10d0 */ 199, 65,  9,194,131,250,  4,126,227, 68, 59,124, 36,228, 15,131,
/* 0x10e0 */ 218,  8,  0,  0,139, 68, 36,212, 72, 99, 92, 36,200, 72,139, 84,
/* 0x10f0 */  36,216, 68, 33,248,137, 68, 36,184, 72, 99,108, 36,184, 72,137,
/* 0x1100 */ 216, 72,193,224,  4, 72,  1,232, 65,129,251,255,255,255,  0, 76,
/* 0x1110 */ 141, 12, 66,119, 26, 76, 57,231, 15,132,150,  8,  0,  0, 15,182,
/* 0x1120 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,
/* 0x1130 */  15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x1140 */  57,194, 15,131,197,  1,  0,  0, 65,137,195,184,  0,  8,  0,  0,
/* 0x1150 */  72,139, 92, 36,216, 41,200, 15,182, 76, 36,204,190,  1,  0,  0,
/* 0x1160 */   0,193,248,  5,141,  4,  2, 65, 15,182,213,102, 65,137,  1,139,
/* 0x1170 */  68, 36,208, 68, 33,248,211,224,185,  8,  0,  0,  0, 43, 76, 36,
/* 0x1180 */ 204,211,250,  1,208,105,192,  0,  3,  0,  0,131,124, 36,200,  6,
/* 0x1190 */ 137,192, 76,141,140, 67,108, 14,  0,  0, 15,142,184,  0,  0,  0,
/* 0x11a0 */  72,139, 84, 36,232, 68,137,248, 68, 41,240, 15,182, 44,  2,  1,
/* 0x11b0 */ 237, 72, 99,214,137,235,129,227,  0,  1,  0,  0, 65,129,251,255,
/* 0x11c0 */ 255,255,  0, 72, 99,195, 73,141,  4, 65, 76,141,  4, 80,119, 26,
/* 0x11d0 */  76, 57,231, 15,132,219,  7,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x11e0 */  65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,144,  0,  2,
/* 0x11f0 */   0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x1200 */ 194,115, 32, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,
/* 0x1210 */ 248,  5,133,219,141,  4,  2,102, 65,137,128,  0,  2,  0,  0,116,
/* 0x1220 */  33,235, 45, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,
/* 0x1230 */ 116, 54,  1,102, 41,194,133,219,102, 65,137,144,  0,  2,  0,  0,
/* 0x1240 */ 116, 14,129,254,255,  0,  0,  0, 15,142, 97,255,255,255,235,120,
/* 0x1250 */ 129,254,255,  0,  0,  0,127,112, 72, 99,198, 65,129,251,255,255,
/* 0x1260 */ 255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132, 67,  7,  0,
/* 0x1270 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1280 */   9,194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x1290 */ 175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,
/* 0x12a0 */ 246, 41,200,193,248,  5,141,  4,  2,102, 65,137,  0,235,161, 65,
/* 0x12b0 */  41,195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,102,
/* 0x12c0 */  41,194,102, 65,137, 16,235,136, 72,139, 76, 36,232, 68,137,248,
/* 0x12d0 */  65,255,199, 65,137,245, 64,136, 52,  1,131,124, 36,200,  3,127,
/* 0x12e0 */  13,199, 68, 36,200,  0,  0,  0,  0,233,166,  6,  0,  0,139, 84,
/* 0x12f0 */  36,200,139, 68, 36,200,131,234,  3,131,232,  6,131,124, 36,200,
/* 0x1300 */   9, 15, 79,208,137, 84, 36,200,233,135,  6,  0,  0, 65, 41,195,
/* 0x1310 */  65, 41,194,137,208,102,193,232,  5,102, 41,194, 72,139, 68, 36,
/* 0x1320 */ 216, 65,129,251,255,255,255,  0,102, 65,137, 17, 72,141, 52, 88,
/* 0x1330 */ 119, 26, 76, 57,231, 15,132,121,  6,  0,  0, 15,182,  7, 65,193,
/* 0x1340 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,128,
/* 0x1350 */   1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x1360 */  57,194,115, 78, 65,137,195,184,  0,  8,  0,  0, 76,139, 76, 36,
/* 0x1370 */ 216, 41,200,139, 76, 36,196, 68,137,116, 36,196,193,248,  5,141,
/* 0x1380 */   4,  2,139, 84, 36,192,137, 76, 36,192,102,137,134,128,  1,  0,
/* 0x1390 */   0, 49,192,131,124, 36,200,  6,137, 84, 36,188, 15,159,192, 73,
/* 0x13a0 */ 129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,200,233, 84,  2,
/* 0x13b0 */   0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,
/* 0x13c0 */ 194, 65,129,251,255,255,255,  0,102,137,150,128,  1,  0,  0,119,
/* 0x13d0 */  26, 76, 57,231, 15,132,218,  5,  0,  0, 15,182,  7, 65,193,226,
/* 0x13e0 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,152,  1,
/* 0x13f0 */   0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x1400 */ 194, 15,131,208,  0,  0,  0, 65,184,  0,  8,  0,  0, 65,137,195,
/* 0x1410 */  72,193,227,  5, 68,137,192, 41,200,193,248,  5,141,  4,  2,102,
/* 0x1420 */ 137,134,152,  1,  0,  0, 72,139, 68, 36,216, 72,  1,216, 65,129,
/* 0x1430 */ 251,255,255,255,  0, 72,141, 52,104,119, 26, 76, 57,231, 15,132,
/* 0x1440 */ 112,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x1450 */ 255,199, 65,  9,194, 15,183,150,224,  1,  0,  0, 68,137,216,193,
/* 0x1460 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 79, 65, 41,200,
/* 0x1470 */  65,137,195, 65,193,248,  5, 69,133,255, 66,141,  4,  2,102,137,
/* 0x1480 */ 134,224,  1,  0,  0, 15,132, 41,  5,  0,  0, 49,192,131,124, 36,
/* 0x1490 */ 200,  6, 72,139, 92, 36,232, 15,159,192,141, 68,  0,  9,137, 68,
/* 0x14a0 */  36,200, 68,137,248, 68, 41,240, 68, 15,182, 44,  3, 68,137,248,
/* 0x14b0 */  65,255,199, 68,136, 44,  3,233,216,  4,  0,  0, 65, 41,195, 65,
/* 0x14c0 */  41,194,137,208,102,193,232,  5,102, 41,194,102,137,150,224,  1,
/* 0x14d0 */   0,  0,233, 17,  1,  0,  0, 65, 41,195, 65, 41,194,137,208,102,
/* 0x14e0 */ 193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,
/* 0x14f0 */ 152,  1,  0,  0,119, 26, 76, 57,231, 15,132,181,  4,  0,  0, 15,
/* 0x1500 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x1510 */  15,183,150,176,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202,
/* 0x1520 */  15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0,
/* 0x1530 */  41,200,193,248,  5,141,  4,  2,102,137,134,176,  1,  0,  0,139,
/* 0x1540 */  68, 36,196,233,152,  0,  0,  0, 65, 41,195, 65, 41,194,137,208,
/* 0x1550 */ 102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,
/* 0x1560 */ 150,176,  1,  0,  0,119, 26, 76, 57,231, 15,132, 68,  4,  0,  0,
/* 0x1570 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x1580 */ 194, 15,183,150,200,  1,  0,  0, 68,137,216,193,232, 11, 15,183,
/* 0x1590 */ 202, 15,175,193, 65, 57,194,115, 29, 65,137,195,184,  0,  8,  0,
/* 0x15a0 */   0, 41,200,193,248,  5,141,  4,  2,102,137,134,200,  1,  0,  0,
/* 0x15b0 */ 139, 68, 36,192,235, 34, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x15c0 */ 232,  5,102, 41,194,139, 68, 36,188,102,137,150,200,  1,  0,  0,
/* 0x15d0 */ 139, 84, 36,192,137, 84, 36,188,139, 76, 36,196,137, 76, 36,192,
/* 0x15e0 */  68,137,116, 36,196, 65,137,198, 49,192,131,124, 36,200,  6, 76,
/* 0x15f0 */ 139, 76, 36,216, 15,159,192, 73,129,193,104, 10,  0,  0,141, 68,
/* 0x1600 */  64,  8,137, 68, 36,200, 65,129,251,255,255,255,  0,119, 26, 76,
/* 0x1610 */  57,231, 15,132,156,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1620 */ 193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,
/* 0x1630 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 39, 65,137,
/* 0x1640 */ 195,184,  0,  8,  0,  0, 69, 49,237, 41,200,193,248,  5,141,  4,
/* 0x1650 */   2,102, 65,137,  1, 72, 99, 68, 36,184, 72,193,224,  4, 77,141,
/* 0x1660 */  68,  1,  4,235,120, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x1670 */   5,102, 41,194, 65,129,251,255,255,255,  0,102, 65,137, 17,119,
/* 0x1680 */  26, 76, 57,231, 15,132, 42,  3,  0,  0, 15,182,  7, 65,193,226,
/* 0x1690 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 81,  2,
/* 0x16a0 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x16b0 */  52, 65,137,195,184,  0,  8,  0,  0, 65,189,  8,  0,  0,  0, 41,
/* 0x16c0 */ 200,193,248,  5,141,  4,  2,102, 65,137, 65,  2, 72, 99, 68, 36,
/* 0x16d0 */ 184, 72,193,224,  4, 77,141,132,  1,  4,  1,  0,  0, 65,185,  3,
/* 0x16e0 */   0,  0,  0,235, 39, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x16f0 */   5, 77,141,129,  4,  2,  0,  0, 65,189, 16,  0,  0,  0,102, 41,
/* 0x1700 */ 194,102, 65,137, 81,  2, 65,185,  8,  0,  0,  0, 68,137,203,189,
/* 0x1710 */   1,  0,  0,  0, 72, 99,197, 65,129,251,255,255,255,  0, 73,141,
/* 0x1720 */  52, 64,119, 26, 76, 57,231, 15,132,135,  2,  0,  0, 15,182,  7,
/* 0x1730 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,
/* 0x1740 */  14, 68,137,216,193,232, 11, 15,183,209, 15,175,194, 65, 57,194,
/* 0x1750 */ 115, 23, 65,137,195,184,  0,  8,  0,  0,  1,237, 41,208,193,248,
/* 0x1760 */   5,141,  4,  1,102,137,  6,235, 22, 65, 41,195, 65, 41,194,137,
/* 0x1770 */ 200,102,193,232,  5,141,108, 45,  1,102, 41,193,102,137, 14,255,
/* 0x1780 */ 203,117,145,184,  1,  0,  0,  0, 68,137,201,211,224, 41,197, 68,
/* 0x1790 */   1,237,131,124, 36,200,  3, 15,143,194,  1,  0,  0,131, 68, 36,
/* 0x17a0 */ 200,  7,184,  3,  0,  0,  0,131,253,  4, 15, 76,197, 72,139, 92,
/* 0x17b0 */  36,216, 65,184,  1,  0,  0,  0, 72,152, 72,193,224,  7, 76,141,
/* 0x17c0 */ 140,  3, 96,  3,  0,  0,187,  6,  0,  0,  0, 73, 99,192, 65,129,
/* 0x17d0 */ 251,255,255,255,  0, 73,141, 52, 65,119, 26, 76, 57,231, 15,132,
/* 0x17e0 */ 208,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x17f0 */ 255,199, 65,  9,194, 15,183, 22, 68,137,216,193,232, 11, 15,183,
/* 0x1800 */ 202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,
/* 0x1810 */   0, 69,  1,192, 41,200,193,248,  5,141,  4,  2,102,137,  6,235,
/* 0x1820 */  23, 65, 41,195, 65, 41,194,137,208,102,193,232,  5, 71,141, 68,
/* 0x1830 */   0,  1,102, 41,194,102,137, 22,255,203,117,143, 65,131,232, 64,
/* 0x1840 */  65,131,248,  3, 69,137,198, 15,142, 13,  1,  0,  0, 65,131,230,
/* 0x1850 */   1, 68,137,192,209,248, 65,131,206,  2, 65,131,248, 13,141,112,
/* 0x1860 */ 255,127, 35,137,241, 72,139, 92, 36,216, 73, 99,192, 65,211,230,
/* 0x1870 */  72,  1,192, 68,137,242, 72,141, 20, 83, 72, 41,194, 76,141,138,
/* 0x1880 */  94,  5,  0,  0,235, 81,141,112,251, 65,129,251,255,255,255,  0,
/* 0x1890 */ 119, 26, 76, 57,231, 15,132, 25,  1,  0,  0, 15,182,  7, 65,193,
/* 0x18a0 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,209,235, 69,
/* 0x18b0 */   1,246, 69, 57,218,114,  7, 69, 41,218, 65,131,206,  1,255,206,
/* 0x18c0 */ 117,199, 76,139, 76, 36,216, 65,193,230,  4,190,  4,  0,  0,  0,
/* 0x18d0 */  73,129,193, 68,  6,  0,  0, 65,189,  1,  0,  0,  0,187,  1,  0,
/* 0x18e0 */   0,  0, 72, 99,195, 65,129,251,255,255,255,  0, 77,141,  4, 65,
/* 0x18f0 */ 119, 26, 76, 57,231, 15,132,185,  0,  0,  0, 15,182,  7, 65,193,
/* 0x1900 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16,
/* 0x1910 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x1920 */  24, 65,137,195,184,  0,  8,  0,  0,  1,219, 41,200,193,248,  5,
/* 0x1930 */ 141,  4,  2,102, 65,137,  0,235, 26, 65, 41,195, 65, 41,194,137,
/* 0x1940 */ 208,102,193,232,  5,141, 92, 27,  1, 69,  9,238,102, 41,194,102,
/* 0x1950 */  65,137, 16, 69,  1,237,255,206,117,136, 65,255,198,116, 64,131,
/* 0x1960 */ 197,  2, 69, 57,254,119, 77, 72,139, 84, 36,232, 68,137,248, 68,
/* 0x1970 */  41,240, 68, 15,182, 44,  2, 68,137,248, 65,255,199,255,205, 68,
/* 0x1980 */ 136, 44,  2, 15,149,194, 49,192, 68, 59,124, 36,228, 15,146,192,
/* 0x1990 */ 133,194,117,211, 68, 59,124, 36,228, 15,130, 69,247,255,255, 65,
/* 0x19a0 */ 129,251,255,255,255,  0,119, 22, 76, 57,231,184,  1,  0,  0,  0,
/* 0x19b0 */ 116, 35,235,  7,184,  1,  0,  0,  0,235, 26, 72,255,199,137,248,
/* 0x19c0 */  43, 68, 36,248, 72,139, 76, 36,240, 72,139, 92, 36, 56,137,  1,
/* 0x19d0 */  68,137, 59, 49,192, 91, 93, 65, 92, 65, 93, 65, 94, 65, 95, 65,
/* 0x19e0 */  87, 72,141, 71,  4, 69, 49,255, 65, 86, 65,190,  1,  0,  0,  0,
/* 0x19f0 */  65, 85, 69, 49,237, 65, 84, 85, 83, 72,137, 76, 36,240, 72,137,
/* 0x1a00 */  68, 36,216,184,  1,  0,  0,  0, 72,137,116, 36,248, 76,137, 68,
/* 0x1a10 */  36,232,137,195, 68,137, 76, 36,228, 15,182, 79,  2,211,227,137,
/* 0x1a20 */ 217, 72,139, 92, 36, 56,255,201,137, 76, 36,212, 15,182, 79,  1,
/* 0x1a30 */ 211,224, 72,139, 76, 36,240,255,200,137, 68, 36,208, 15,182,  7,
/* 0x1a40 */ 199,  1,  0,  0,  0,  0,199, 68, 36,200,  0,  0,  0,  0,199, 68,
/* 0x1a50 */  36,196,  1,  0,  0,  0,199, 68, 36,192,  1,  0,  0,  0,199, 68,
/* 0x1a60 */  36,188,  1,  0,  0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,204,
/* 0x1a70 */  15,182, 79,  1,  1,193,184,  0,  3,  0,  0,211,224, 49,201,141,
/* 0x1a80 */ 184, 54,  7,  0,  0, 65, 57,255,115, 19, 72,139, 92, 36,216,137,
/* 0x1a90 */ 200,255,193, 57,249,102,199,  4, 67,  0,  4,235,235, 72,139,124,
/* 0x1aa0 */  36,248,137,208, 69, 49,210, 65,131,203,255, 49,210, 73,137,252,
/* 0x1ab0 */  73,  1,196, 76, 57,231, 15,132,239,  8,  0,  0, 15,182,  7, 65,
/* 0x1ac0 */ 193,226,  8,255,194, 72,255,199, 65,  9,194,131,250,  4,126,227,
/* 0x1ad0 */  68, 59,124, 36,228, 15,131,218,  8,  0,  0,139, 68, 36,212, 72,
/* 0x1ae0 */  99, 92, 36,200, 72,139, 84, 36,216, 68, 33,248,137, 68, 36,184,
/* 0x1af0 */  72, 99,108, 36,184, 72,137,216, 72,193,224,  4, 72,  1,232, 65,
/* 0x1b00 */ 129,251,255,255,255,  0, 76,141, 12, 66,119, 26, 76, 57,231, 15,
/* 0x1b10 */ 132,150,  8,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x1b20 */  72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11,
/* 0x1b30 */  15,183,202, 15,175,193, 65, 57,194, 15,131,197,  1,  0,  0, 65,
/* 0x1b40 */ 137,195,184,  0,  8,  0,  0, 72,139, 92, 36,216, 41,200, 15,182,
/* 0x1b50 */  76, 36,204,190,  1,  0,  0,  0,193,248,  5,141,  4,  2, 65, 15,
/* 0x1b60 */ 182,213,102, 65,137,  1,139, 68, 36,208, 68, 33,248,211,224,185,
/* 0x1b70 */   8,  0,  0,  0, 43, 76, 36,204,211,250,  1,208,105,192,  0,  3,
/* 0x1b80 */   0,  0,131,124, 36,200,  6,137,192, 76,141,140, 67,108, 14,  0,
/* 0x1b90 */   0, 15,142,184,  0,  0,  0, 72,139, 84, 36,232, 68,137,248, 68,
/* 0x1ba0 */  41,240, 15,182, 44,  2,  1,237, 72, 99,214,137,235,129,227,  0,
/* 0x1bb0 */   1,  0,  0, 65,129,251,255,255,255,  0, 72, 99,195, 73,141,  4,
/* 0x1bc0 */  65, 76,141,  4, 80,119, 26, 76, 57,231, 15,132,219,  7,  0,  0,
/* 0x1bd0 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x1be0 */ 194, 65, 15,183,144,  0,  2,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x1bf0 */ 183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,
/* 0x1c00 */   0,  0,  1,246, 41,200,193,248,  5,133,219,141,  4,  2,102, 65,
/* 0x1c10 */ 137,128,  0,  2,  0,  0,116, 33,235, 45, 65, 41,195, 65, 41,194,
/* 0x1c20 */ 137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,133,219,102,
/* 0x1c30 */  65,137,144,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,
/* 0x1c40 */ 142, 97,255,255,255,235,120,129,254,255,  0,  0,  0,127,112, 72,
/* 0x1c50 */  99,198, 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76,
/* 0x1c60 */  57,231, 15,132, 67,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1c70 */ 193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,
/* 0x1c80 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,
/* 0x1c90 */ 195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,141,  4,  2,
/* 0x1ca0 */ 102, 65,137,  0,235,161, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x1cb0 */ 232,  5,141,116, 54,  1,102, 41,194,102, 65,137, 16,235,136, 72,
/* 0x1cc0 */ 139, 76, 36,232, 68,137,248, 65,255,199, 65,137,245, 64,136, 52,
/* 0x1cd0 */   1,131,124, 36,200,  3,127, 13,199, 68, 36,200,  0,  0,  0,  0,
/* 0x1ce0 */ 233,166,  6,  0,  0,139, 84, 36,200,139, 68, 36,200,131,234,  3,
/* 0x1cf0 */ 131,232,  6,131,124, 36,200,  9, 15, 79,208,137, 84, 36,200,233,
/* 0x1d00 */ 135,  6,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x1d10 */ 102, 41,194, 72,139, 68, 36,216, 65,129,251,255,255,255,  0,102,
/* 0x1d20 */  65,137, 17, 72,141, 52, 88,119, 26, 76, 57,231, 15,132,121,  6,
/* 0x1d30 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x1d40 */  65,  9,194, 15,183,150,128,  1,  0,  0, 68,137,216,193,232, 11,
/* 0x1d50 */  15,183,202, 15,175,193, 65, 57,194,115, 78, 65,137,195,184,  0,
/* 0x1d60 */   8,  0,  0, 76,139, 76, 36,216, 41,200,139, 76, 36,196, 68,137,
/* 0x1d70 */ 116, 36,196,193,248,  5,141,  4,  2,139, 84, 36,192,137, 76, 36,
/* 0x1d80 */ 192,102,137,134,128,  1,  0,  0, 49,192,131,124, 36,200,  6,137,
/* 0x1d90 */  84, 36,188, 15,159,192, 73,129,193,100,  6,  0,  0,141,  4, 64,
/* 0x1da0 */ 137, 68, 36,200,233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,137,
/* 0x1db0 */ 208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,
/* 0x1dc0 */ 137,150,128,  1,  0,  0,119, 26, 76, 57,231, 15,132,218,  5,  0,
/* 0x1dd0 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1de0 */   9,194, 15,183,150,152,  1,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x1df0 */ 183,202, 15,175,193, 65, 57,194, 15,131,208,  0,  0,  0, 65,184,
/* 0x1e00 */   0,  8,  0,  0, 65,137,195, 72,193,227,  5, 68,137,192, 41,200,
/* 0x1e10 */ 193,248,  5,141,  4,  2,102,137,134,152,  1,  0,  0, 72,139, 68,
/* 0x1e20 */  36,216, 72,  1,216, 65,129,251,255,255,255,  0, 72,141, 52,104,
/* 0x1e30 */ 119, 26, 76, 57,231, 15,132,112,  5,  0,  0, 15,182,  7, 65,193,
/* 0x1e40 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,224,
/* 0x1e50 */   1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x1e60 */  57,194,115, 79, 65, 41,200, 65,137,195, 65,193,248,  5, 69,133,
/* 0x1e70 */ 255, 66,141,  4,  2,102,137,134,224,  1,  0,  0, 15,132, 41,  5,
/* 0x1e80 */   0,  0, 49,192,131,124, 36,200,  6, 72,139, 92, 36,232, 15,159,
/* 0x1e90 */ 192,141, 68,  0,  9,137, 68, 36,200, 68,137,248, 68, 41,240, 68,
/* 0x1ea0 */  15,182, 44,  3, 68,137,248, 65,255,199, 68,136, 44,  3,233,216,
/* 0x1eb0 */   4,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x1ec0 */  41,194,102,137,150,224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,
/* 0x1ed0 */ 195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,
/* 0x1ee0 */ 255,255,255,  0,102,137,150,152,  1,  0,  0,119, 26, 76, 57,231,
/* 0x1ef0 */  15,132,181,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x1f00 */   8, 72,255,199, 65,  9,194, 15,183,150,176,  1,  0,  0, 68,137,
/* 0x1f10 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,
/* 0x1f20 */ 137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x1f30 */ 137,134,176,  1,  0,  0,139, 68, 36,196,233,152,  0,  0,  0, 65,
/* 0x1f40 */  41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,
/* 0x1f50 */ 251,255,255,255,  0,102,137,150,176,  1,  0,  0,119, 26, 76, 57,
/* 0x1f60 */ 231, 15,132, 68,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x1f70 */ 227,  8, 72,255,199, 65,  9,194, 15,183,150,200,  1,  0,  0, 68,
/* 0x1f80 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 29,
/* 0x1f90 */  65,137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,
/* 0x1fa0 */ 102,137,134,200,  1,  0,  0,139, 68, 36,192,235, 34, 65, 41,195,
/* 0x1fb0 */  65, 41,194,137,208,102,193,232,  5,102, 41,194,139, 68, 36,188,
/* 0x1fc0 */ 102,137,150,200,  1,  0,  0,139, 84, 36,192,137, 84, 36,188,139,
/* 0x1fd0 */  76, 36,196,137, 76, 36,192, 68,137,116, 36,196, 65,137,198, 49,
/* 0x1fe0 */ 192,131,124, 36,200,  6, 76,139, 76, 36,216, 15,159,192, 73,129,
/* 0x1ff0 */ 193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,200, 65,129,251,
/* 0x2000 */ 255,255,255,  0,119, 26, 76, 57,231, 15,132,156,  3,  0,  0, 15,
/* 0x2010 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x2020 */  65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x2030 */  65, 57,194,115, 39, 65,137,195,184,  0,  8,  0,  0, 69, 49,237,
/* 0x2040 */  41,200,193,248,  5,141,  4,  2,102, 65,137,  1, 72, 99, 68, 36,
/* 0x2050 */ 184, 72,193,224,  4, 77,141, 68,  1,  4,235,120, 65, 41,195, 65,
/* 0x2060 */  41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,
/* 0x2070 */ 255,  0,102, 65,137, 17,119, 26, 76, 57,231, 15,132, 42,  3,  0,
/* 0x2080 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x2090 */   9,194, 65, 15,183, 81,  2, 68,137,216,193,232, 11, 15,183,202,
/* 0x20a0 */  15,175,193, 65, 57,194,115, 52, 65,137,195,184,  0,  8,  0,  0,
/* 0x20b0 */  65,189,  8,  0,  0,  0, 41,200,193,248,  5,141,  4,  2,102, 65,
/* 0x20c0 */ 137, 65,  2, 72, 99, 68, 36,184, 72,193,224,  4, 77,141,132,  1,
/* 0x20d0 */   4,  1,  0,  0, 65,185,  3,  0,  0,  0,235, 39, 65, 41,195, 65,
/* 0x20e0 */  41,194,137,208,102,193,232,  5, 77,141,129,  4,  2,  0,  0, 65,
/* 0x20f0 */ 189, 16,  0,  0,  0,102, 41,194,102, 65,137, 81,  2, 65,185,  8,
/* 0x2100 */   0,  0,  0, 68,137,203,189,  1,  0,  0,  0, 72, 99,197, 65,129,
/* 0x2110 */ 251,255,255,255,  0, 73,141, 52, 64,119, 26, 76, 57,231, 15,132,
/* 0x2120 */ 135,  2,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x2130 */ 255,199, 65,  9,194, 15,183, 14, 68,137,216,193,232, 11, 15,183,
/* 0x2140 */ 209, 15,175,194, 65, 57,194,115, 23, 65,137,195,184,  0,  8,  0,
/* 0x2150 */   0,  1,237, 41,208,193,248,  5,141,  4,  1,102,137,  6,235, 22,
/* 0x2160 */  65, 41,195, 65, 41,194,137,200,102,193,232,  5,141,108, 45,  1,
/* 0x2170 */ 102, 41,193,102,137, 14,255,203,117,145,184,  1,  0,  0,  0, 68,
/* 0x2180 */ 137,201,211,224, 41,197, 68,  1,237,131,124, 36,200,  3, 15,143,
/* 0x2190 */ 194,  1,  0,  0,131, 68, 36,200,  7,184,  3,  0,  0,  0,131,253,
/* 0x21a0 */   4, 15, 76,197, 72,139, 92, 36,216, 65,184,  1,  0,  0,  0, 72,
/* 0x21b0 */ 152, 72,193,224,  7, 76,141,140,  3, 96,  3,  0,  0,187,  6,  0,
/* 0x21c0 */   0,  0, 73, 99,192, 65,129,251,255,255,255,  0, 73,141, 52, 65,
/* 0x21d0 */ 119, 26, 76, 57,231, 15,132,208,  1,  0,  0, 15,182,  7, 65,193,
/* 0x21e0 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183, 22, 68,
/* 0x21f0 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24,
/* 0x2200 */  65,137,195,184,  0,  8,  0,  0, 69,  1,192, 41,200,193,248,  5,
/* 0x2210 */ 141,  4,  2,102,137,  6,235, 23, 65, 41,195, 65, 41,194,137,208,
/* 0x2220 */ 102,193,232,  5, 71,141, 68,  0,  1,102, 41,194,102,137, 22,255,
/* 0x2230 */ 203,117,143, 65,131,232, 64, 65,131,248,  3, 69,137,198, 15,142,
/* 0x2240 */  13,  1,  0,  0, 65,131,230,  1, 68,137,192,209,248, 65,131,206,
/* 0x2250 */   2, 65,131,248, 13,141,112,255,127, 35,137,241, 72,139, 92, 36,
/* 0x2260 */ 216, 73, 99,192, 65,211,230, 72,  1,192, 68,137,242, 72,141, 20,
/* 0x2270 */  83, 72, 41,194, 76,141,138, 94,  5,  0,  0,235, 81,141,112,251,
/* 0x2280 */  65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,132, 25,  1,
/* 0x2290 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x22a0 */  65,  9,194, 65,209,235, 69,  1,246, 69, 57,218,114,  7, 69, 41,
/* 0x22b0 */ 218, 65,131,206,  1,255,206,117,199, 76,139, 76, 36,216, 65,193,
/* 0x22c0 */ 230,  4,190,  4,  0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,189,
/* 0x22d0 */   1,  0,  0,  0,187,  1,  0,  0,  0, 72, 99,195, 65,129,251,255,
/* 0x22e0 */ 255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132,185,  0,
/* 0x22f0 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x2300 */  65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202,
/* 0x2310 */  15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,
/* 0x2320 */   1,219, 41,200,193,248,  5,141,  4,  2,102, 65,137,  0,235, 26,
/* 0x2330 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,141, 92, 27,  1,
/* 0x2340 */  69,  9,238,102, 41,194,102, 65,137, 16, 69,  1,237,255,206,117,
/* 0x2350 */ 136, 65,255,198,116, 64,131,197,  2, 69, 57,254,119, 77, 72,139,
/* 0x2360 */  84, 36,232, 68,137,248, 68, 41,240, 68, 15,182, 44,  2, 68,137,
/* 0x2370 */ 248, 65,255,199,255,205, 68,136, 44,  2, 15,149,194, 49,192, 68,
/* 0x2380 */  59,124, 36,228, 15,146,192,133,194,117,211, 68, 59,124, 36,228,
/* 0x2390 */  15,130, 69,247,255,255, 65,129,251,255,255,255,  0,119, 22, 76,
/* 0x23a0 */  57,231,184,  1,  0,  0,  0,116, 35,235,  7,184,  1,  0,  0,  0,
/* 0x23b0 */ 235, 26, 72,255,199,137,248, 43, 68, 36,248, 72,139, 76, 36,240,
/* 0x23c0 */  72,139, 92, 36, 56,137,  1, 68,137, 59, 49,192, 91, 93, 65, 92,
/* 0x23d0 */  65, 93, 65, 94, 65, 95, 72,139,117,248, 72,139,125,  8,139, 75,
/* 0x23e0 */   4, 72,  1,206,139, 19, 72,  1,215,201,233,  0,  0,  0,  0,  0,
/* 0x23f0 */  68,137,193,131,200,255,204,244, 88, 72, 41,199, 88, 89,137, 57,
/* 0x2400 */  72, 41,240,195,117,112,120,  0, 47,100,101,118, 47,115,104,109,
/* 0x2410 */   0, 85, 80, 88, 45, 53, 46, 48, 32,119, 97,110,116,115, 32,109,
/* 0x2420 */ 101,109,102,100, 95, 99,114,101, 97,116,101, 40, 41, 44, 32,111,
/* 0x2430 */ 114, 32,110,101,101,100,115, 32, 47,100,101,118, 47,115,104,109,
/* 0x2440 */  40, 44, 79, 95, 84, 77, 80, 70, 73, 76, 69, 44, 41, 10,  0,117,
/* 0x2450 */ 112,120,  0,117,112,120,  0,  0, 46,115,121,109,116, 97, 98,  0,
/* 0x2460 */  46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116, 97,
/* 0x2470 */  98,  0, 46,114,101,108, 97, 46,116,101,120,116,  0, 46,114,101,
/* 0x2480 */ 108, 97, 85, 77, 70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,108,
/* 0x2490 */  97, 83, 89, 83, 67, 65, 76, 76, 83,  0, 69, 88, 80, 95, 72, 69,
/* 0x24a0 */  65, 68,  0, 46,114,101,108, 97, 78, 82, 86, 50, 69,  0, 46,114,
/* 0x24b0 */ 101,108, 97, 78, 82, 86, 50, 68,  0, 46,114,101,108, 97, 78, 82,
/* 0x24c0 */  86, 50, 66,  0, 46,114,101,108, 97, 76, 90, 77, 65, 95, 68, 65,
/* 0x24d0 */  73, 83, 89,  0, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  0, 76,
/* 0x24e0 */  90, 77, 65, 95, 68, 69, 67, 49, 48,  0, 76, 90, 77, 65, 95, 68,
/* 0x24f0 */  69, 67, 50, 48,  0, 46,114,101,108, 97, 76, 90, 77, 65, 95, 68,
/* 0x2500 */  69, 67, 51, 48,  0, 69, 88, 80, 95, 84, 65, 73, 76,  0, 83, 84,
/* 0x2510 */  82, 67, 79, 78,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2520 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2530 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2540 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2550 */   0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0,  1,  0,  0,  0,
/* 0x2560 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2570 */  64,  0,  0,  0,  0,  0,  0,  0,244,  9,  0,  0,  0,  0,  0,  0,
/* 0x2580 */   0,  0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2590 */   0,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  4,  0,  0,  0,
/* 0x25a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25b0 */  88, 48,  0,  0,  0,  0,  0,  0,216,  3,  0,  0,  0,  0,  0,  0,
/* 0x25c0 */  24,  0,  0,  0,  1,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x25d0 */  24,  0,  0,  0,  0,  0,  0,  0, 43,  0,  0,  0,  1,  0,  0,  0,
/* 0x25e0 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25f0 */  52, 10,  0,  0,  0,  0,  0,  0,249,  0,  0,  0,  0,  0,  0,  0,
/* 0x2600 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x2610 */   0,  0,  0,  0,  0,  0,  0,  0, 38,  0,  0,  0,  4,  0,  0,  0,
/* 0x2620 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2630 */  48, 52,  0,  0,  0,  0,  0,  0,  8,  1,  0,  0,  0,  0,  0,  0,
/* 0x2640 */  24,  0,  0,  0,  3,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2650 */  24,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0,  1,  0,  0,  0,
/* 0x2660 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2670 */  45, 11,  0,  0,  0,  0,  0,  0,220,  0,  0,  0,  0,  0,  0,  0,
/* 0x2680 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2690 */   0,  0,  0,  0,  0,  0,  0,  0, 53,  0,  0,  0,  4,  0,  0,  0,
/* 0x26a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x26b0 */  56, 53,  0,  0,  0,  0,  0,  0,144,  0,  0,  0,  0,  0,  0,  0,
/* 0x26c0 */  24,  0,  0,  0,  5,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x26d0 */  24,  0,  0,  0,  0,  0,  0,  0, 67,  0,  0,  0,  1,  0,  0,  0,
/* 0x26e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x26f0 */   9, 12,  0,  0,  0,  0,  0,  0,233,  0,  0,  0,  0,  0,  0,  0,
/* 0x2700 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2710 */   0,  0,  0,  0,  0,  0,  0,  0, 81,  0,  0,  0,  1,  0,  0,  0,
/* 0x2720 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2730 */ 242, 12,  0,  0,  0,  0,  0,  0,232,  0,  0,  0,  0,  0,  0,  0,
/* 0x2740 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2750 */   0,  0,  0,  0,  0,  0,  0,  0, 76,  0,  0,  0,  4,  0,  0,  0,
/* 0x2760 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2770 */ 200, 53,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x2780 */  24,  0,  0,  0,  8,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2790 */  24,  0,  0,  0,  0,  0,  0,  0, 92,  0,  0,  0,  1,  0,  0,  0,
/* 0x27a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27b0 */ 218, 13,  0,  0,  0,  0,  0,  0,219,  0,  0,  0,  0,  0,  0,  0,
/* 0x27c0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x27d0 */   0,  0,  0,  0,  0,  0,  0,  0, 87,  0,  0,  0,  4,  0,  0,  0,
/* 0x27e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27f0 */ 248, 53,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x2800 */  24,  0,  0,  0, 10,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2810 */  24,  0,  0,  0,  0,  0,  0,  0,103,  0,  0,  0,  1,  0,  0,  0,
/* 0x2820 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2830 */ 181, 14,  0,  0,  0,  0,  0,  0,196,  0,  0,  0,  0,  0,  0,  0,
/* 0x2840 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2850 */   0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  4,  0,  0,  0,
/* 0x2860 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2870 */  40, 54,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x2880 */  24,  0,  0,  0, 12,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2890 */  24,  0,  0,  0,  0,  0,  0,  0,114,  0,  0,  0,  1,  0,  0,  0,
/* 0x28a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28b0 */ 121, 15,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,
/* 0x28c0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x28d0 */   0,  0,  0,  0,  0,  0,  0,  0,109,  0,  0,  0,  4,  0,  0,  0,
/* 0x28e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28f0 */  88, 54,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2900 */  24,  0,  0,  0, 14,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2910 */  24,  0,  0,  0,  0,  0,  0,  0,125,  0,  0,  0,  1,  0,  0,  0,
/* 0x2920 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2930 */ 131, 15,  0,  0,  0,  0,  0,  0,101,  0,  0,  0,  0,  0,  0,  0,
/* 0x2940 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2950 */   0,  0,  0,  0,  0,  0,  0,  0,136,  0,  0,  0,  1,  0,  0,  0,
/* 0x2960 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2970 */ 232, 15,  0,  0,  0,  0,  0,  0,247,  9,  0,  0,  0,  0,  0,  0,
/* 0x2980 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2990 */   0,  0,  0,  0,  0,  0,  0,  0,147,  0,  0,  0,  1,  0,  0,  0,
/* 0x29a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x29b0 */ 223, 25,  0,  0,  0,  0,  0,  0,247,  9,  0,  0,  0,  0,  0,  0,
/* 0x29c0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x29d0 */   0,  0,  0,  0,  0,  0,  0,  0,163,  0,  0,  0,  1,  0,  0,  0,
/* 0x29e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x29f0 */ 214, 35,  0,  0,  0,  0,  0,  0, 25,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a00 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a10 */   0,  0,  0,  0,  0,  0,  0,  0,158,  0,  0,  0,  4,  0,  0,  0,
/* 0x2a20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a30 */ 112, 54,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a40 */  24,  0,  0,  0, 19,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a50 */  24,  0,  0,  0,  0,  0,  0,  0,174,  0,  0,  0,  1,  0,  0,  0,
/* 0x2a60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a70 */ 240, 35,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a80 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a90 */   0,  0,  0,  0,  0,  0,  0,  0,183,  0,  0,  0,  1,  0,  0,  0,
/* 0x2aa0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ab0 */   4, 36,  0,  0,  0,  0,  0,  0, 83,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ac0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ad0 */   0,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,
/* 0x2ae0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2af0 */  87, 36,  0,  0,  0,  0,  0,  0,190,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b00 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b10 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,
/* 0x2b20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b30 */ 152, 43,  0,  0,  0,  0,  0,  0,216,  3,  0,  0,  0,  0,  0,  0,
/* 0x2b40 */  25,  0,  0,  0, 15,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b50 */  24,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,
/* 0x2b60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b70 */ 112, 47,  0,  0,  0,  0,  0,  0,229,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b80 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ba0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bb0 */   0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  5,  0,
/* 0x2bd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2be0 */   0,  0,  0,  0,  3,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bf0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 19,  0,
/* 0x2c00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c10 */   0,  0,  0,  0,  3,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 22,  0,
/* 0x2c30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c40 */   0,  0,  0,  0,  3,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  8,  0,
/* 0x2c60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c70 */   0,  0,  0,  0,  3,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 12,  0,
/* 0x2c90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ca0 */   0,  0,  0,  0,  3,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 16,  0,
/* 0x2cc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cd0 */   0,  0,  0,  0,  3,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ce0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 18,  0,
/* 0x2cf0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d00 */   1,  0,  0,  0, 16,  0,  5,  0, 74,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d10 */   0,  0,  0,  0,  0,  0,  0,  0,  6,  0,  0,  0, 16,  0,  7,  0,
/* 0x2d20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d30 */  15,  0,  0,  0, 16,  0,  1,  0, 99,  1,  0,  0,  0,  0,  0,  0,
/* 0x2d40 */   0,  0,  0,  0,  0,  0,  0,  0, 29,  0,  0,  0, 16,  0,  5,  0,
/* 0x2d50 */ 180,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d60 */  36,  0,  0,  0, 16,  0, 21,  0, 20,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d70 */   0,  0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0, 18,  0,  1,  0,
/* 0x2d80 */  36,  3,  0,  0,  0,  0,  0,  0, 43,  1,  0,  0,  0,  0,  0,  0,
/* 0x2d90 */  64,  0,  0,  0, 16,  0,  5,  0,118,  0,  0,  0,  0,  0,  0,  0,
/* 0x2da0 */   0,  0,  0,  0,  0,  0,  0,  0, 70,  0,  0,  0, 16,  0,  5,  0,
/* 0x2db0 */ 196,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2dc0 */  80,  0,  0,  0, 16,  0,  5,  0, 91,  0,  0,  0,  0,  0,  0,  0,
/* 0x2dd0 */   0,  0,  0,  0,  0,  0,  0,  0, 85,  0,  0,  0, 18,  0,  3,  0,
/* 0x2de0 */   0,  0,  0,  0,  0,  0,  0,  0,249,  0,  0,  0,  0,  0,  0,  0,
/* 0x2df0 */ 107,  0,  0,  0, 16,  0,  5,  0,212,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e00 */   0,  0,  0,  0,  0,  0,  0,  0,113,  0,  0,  0, 18,  0,  1,  0,
/* 0x2e10 */ 197,  8,  0,  0,  0,  0,  0,  0, 47,  1,  0,  0,  0,  0,  0,  0,
/* 0x2e20 */ 123,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e30 */   0,  0,  0,  0,  0,  0,  0,  0,136,  0,  0,  0, 16,  0,  5,  0,
/* 0x2e40 */ 216,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e50 */ 141,  0,  0,  0, 18,  0,  1,  0,217,  2,  0,  0,  0,  0,  0,  0,
/* 0x2e60 */  75,  0,  0,  0,  0,  0,  0,  0,150,  0,  0,  0, 16,  0,  5,  0,
/* 0x2e70 */ 208,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e80 */ 156,  0,  0,  0, 16,  0,  5,  0, 17,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e90 */   0,  0,  0,  0,  0,  0,  0,  0,169,  0,  0,  0, 16,  0,  5,  0,
/* 0x2ea0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2eb0 */ 177,  0,  0,  0, 16,  0,  5,  0,143,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ec0 */   0,  0,  0,  0,  0,  0,  0,  0,186,  0,  0,  0, 16,  0,  5,  0,
/* 0x2ed0 */ 212,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ee0 */ 193,  0,  0,  0, 16,  0,  5,  0,164,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ef0 */   0,  0,  0,  0,  0,  0,  0,  0,200,  0,  0,  0, 16,  0,  5,  0,
/* 0x2f00 */ 184,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f10 */ 205,  0,  0,  0, 16,  0,  5,  0,188,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f20 */   0,  0,  0,  0,  0,  0,  0,  0,209,  0,  0,  0, 16,  0,  5,  0,
/* 0x2f30 */ 200,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f40 */ 214,  0,  0,  0, 16,  0,  5,  0,204,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f50 */   0,  0,  0,  0,  0,  0,  0,  0,223,  0,  0,  0, 16,  0,  5,  0,
/* 0x2f60 */ 192,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f70 */   0, 80,109, 97,112,  0,102, 95,101,120,112, 97,110,100,  0,103,
/* 0x2f80 */ 101,116, 95,112, 97,103,101, 95,109, 97,115,107,  0,109,117,110,
/* 0x2f90 */ 109, 97,112,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,100,
/* 0x2fa0 */  95,102,100,  0,120,102,105,110,100, 95,112, 97,103,101,115,  0,
/* 0x2fb0 */  80,115,121,110, 99,  0,102,116,114,117,110, 99, 97,116,101,  0,
/* 0x2fc0 */ 109,109, 97,112,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x2fd0 */ 100, 95,102,100, 95,108,105,110,117,120,  0,119,114,105,116,101,
/* 0x2fe0 */   0,117,112,120, 95,109, 97,105,110, 50,  0,109,101,109,102,100,
/* 0x2ff0 */  95, 99,114,101, 97,116,101,  0,114,101, 97,100,  0,117,110,100,
/* 0x3000 */ 101,114,108, 97,121,  0,109,115,121,110, 99,  0,117,112,120,102,
/* 0x3010 */ 100, 95, 99,114,101, 97,116,101,  0,109,121, 95, 98,107,112,116,
/* 0x3020 */   0, 80,112,114,111,116,101, 99,116,  0, 80,119,114,105,116,101,
/* 0x3030 */   0, 80,117,110,109, 97,112,  0,101,120,105,116,  0, 98,114,107,
/* 0x3040 */   0,111,112,101,110,  0,109,112,114,111,116,101, 99,116,  0, 99,
/* 0x3050 */ 108,111,115,101,  0,  0,  0,  0,128,  0,  0,  0,  0,  0,  0,  0,
/* 0x3060 */   2,  0,  0,  0,  2,  0,  0,  0,254,255,255,255,255,255,255,255,
/* 0x3070 */ 135,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 38,  0,  0,  0,
/* 0x3080 */ 252,255,255,255,255,255,255,255, 16,  1,  0,  0,  0,  0,  0,  0,
/* 0x3090 */   2,  0,  0,  0, 26,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x30a0 */  51,  1,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 18,  0,  0,  0,
/* 0x30b0 */ 252,255,255,255,255,255,255,255, 79,  1,  0,  0,  0,  0,  0,  0,
/* 0x30c0 */   2,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x30d0 */  86,  1,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 40,  0,  0,  0,
/* 0x30e0 */ 252,255,255,255,255,255,255,255,128,  1,  0,  0,  0,  0,  0,  0,
/* 0x30f0 */   4,  0,  0,  0, 36,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3100 */ 246,  1,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 36,  0,  0,  0,
/* 0x3110 */ 252,255,255,255,255,255,255,255, 33,  2,  0,  0,  0,  0,  0,  0,
/* 0x3120 */   4,  0,  0,  0, 16,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3130 */ 205,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 36,  0,  0,  0,
/* 0x3140 */ 252,255,255,255,255,255,255,255,  9,  3,  0,  0,  0,  0,  0,  0,
/* 0x3150 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3160 */  80,  3,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x3170 */ 252,255,255,255,255,255,255,255,237,  3,  0,  0,  0,  0,  0,  0,
/* 0x3180 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3190 */  24,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 18,  0,  0,  0,
/* 0x31a0 */ 252,255,255,255,255,255,255,255, 41,  4,  0,  0,  0,  0,  0,  0,
/* 0x31b0 */   4,  0,  0,  0, 18,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x31c0 */ 217,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 23,  0,  0,  0,
/* 0x31d0 */ 252,255,255,255,255,255,255,255,  2,  5,  0,  0,  0,  0,  0,  0,
/* 0x31e0 */   4,  0,  0,  0, 20,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x31f0 */  12,  5,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x3200 */ 252,255,255,255,255,255,255,255, 73,  6,  0,  0,  0,  0,  0,  0,
/* 0x3210 */   2,  0,  0,  0,  6,  0,  0,  0, 71,  0,  0,  0,  0,  0,  0,  0,
/* 0x3220 */  78,  6,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 31,  0,  0,  0,
/* 0x3230 */ 252,255,255,255,255,255,255,255, 92,  6,  0,  0,  0,  0,  0,  0,
/* 0x3240 */   4,  0,  0,  0, 22,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3250 */ 153,  6,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 23,  0,  0,  0,
/* 0x3260 */ 252,255,255,255,255,255,255,255,195,  6,  0,  0,  0,  0,  0,  0,
/* 0x3270 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3280 */ 146,  7,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  6,  0,  0,  0,
/* 0x3290 */  75,  0,  0,  0,  0,  0,  0,  0,151,  7,  0,  0,  0,  0,  0,  0,
/* 0x32a0 */   4,  0,  0,  0, 31,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x32b0 */ 170,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 25,  0,  0,  0,
/* 0x32c0 */ 252,255,255,255,255,255,255,255,198,  7,  0,  0,  0,  0,  0,  0,
/* 0x32d0 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x32e0 */ 208,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 40,  0,  0,  0,
/* 0x32f0 */ 252,255,255,255,255,255,255,255,247,  7,  0,  0,  0,  0,  0,  0,
/* 0x3300 */   4,  0,  0,  0, 21,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3310 */   2,  8,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 18,  0,  0,  0,
/* 0x3320 */ 252,255,255,255,255,255,255,255, 30,  8,  0,  0,  0,  0,  0,  0,
/* 0x3330 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3340 */  44,  8,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 40,  0,  0,  0,
/* 0x3350 */ 252,255,255,255,255,255,255,255, 68,  8,  0,  0,  0,  0,  0,  0,
/* 0x3360 */   4,  0,  0,  0, 33,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3370 */  82,  8,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 36,  0,  0,  0,
/* 0x3380 */ 252,255,255,255,255,255,255,255,123,  8,  0,  0,  0,  0,  0,  0,
/* 0x3390 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x33a0 */ 173,  8,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 37,  0,  0,  0,
/* 0x33b0 */ 252,255,255,255,255,255,255,255, 40,  9,  0,  0,  0,  0,  0,  0,
/* 0x33c0 */   4,  0,  0,  0, 17,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x33d0 */ 123,  9,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 38,  0,  0,  0,
/* 0x33e0 */ 252,255,255,255,255,255,255,255,144,  9,  0,  0,  0,  0,  0,  0,
/* 0x33f0 */   4,  0,  0,  0, 28,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3400 */ 162,  9,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 36,  0,  0,  0,
/* 0x3410 */ 252,255,255,255,255,255,255,255,209,  9,  0,  0,  0,  0,  0,  0,
/* 0x3420 */   4,  0,  0,  0, 40,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3430 */  33,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  6,  0,  0,  0,
/* 0x3440 */ 252,255,255,255,255,255,255,255, 46,  0,  0,  0,  0,  0,  0,  0,
/* 0x3450 */   4,  0,  0,  0, 27,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3460 */  66,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 27,  0,  0,  0,
/* 0x3470 */ 252,255,255,255,255,255,255,255, 79,  0,  0,  0,  0,  0,  0,  0,
/* 0x3480 */   2,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3490 */  94,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 38,  0,  0,  0,
/* 0x34a0 */ 252,255,255,255,255,255,255,255,115,  0,  0,  0,  0,  0,  0,  0,
/* 0x34b0 */   2,  0,  0,  0,  6,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x34c0 */ 130,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 25,  0,  0,  0,
/* 0x34d0 */ 252,255,255,255,255,255,255,255,140,  0,  0,  0,  0,  0,  0,  0,
/* 0x34e0 */   4,  0,  0,  0, 36,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x34f0 */ 150,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x3500 */ 252,255,255,255,255,255,255,255,194,  0,  0,  0,  0,  0,  0,  0,
/* 0x3510 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3520 */ 202,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x3530 */ 252,255,255,255,255,255,255,255, 77,  0,  0,  0,  0,  0,  0,  0,
/* 0x3540 */   2,  0,  0,  0,  1,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3550 */ 120,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  0,  0,  0,
/* 0x3560 */ 252,255,255,255,255,255,255,255,145,  0,  0,  0,  0,  0,  0,  0,
/* 0x3570 */   2,  0,  0,  0,  1,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3580 */ 166,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  0,  0,  0,
/* 0x3590 */ 252,255,255,255,255,255,255,255,139,  0,  0,  0,  0,  0,  0,  0,
/* 0x35a0 */   2,  0,  0,  0, 30,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x35b0 */ 160,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 39,  0,  0,  0,
/* 0x35c0 */ 252,255,255,255,255,255,255,255,223,  0,  0,  0,  0,  0,  0,  0,
/* 0x35d0 */   2,  0,  0,  0,  3,  0,  0,  0,165,  0,  0,  0,  0,  0,  0,  0,
/* 0x35e0 */ 116,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  5,  0,  0,  0,
/* 0x35f0 */   4,  0,  0,  0,  0,  0,  0,  0,210,  0,  0,  0,  0,  0,  0,  0,
/* 0x3600 */   2,  0,  0,  0,  3,  0,  0,  0,165,  0,  0,  0,  0,  0,  0,  0,
/* 0x3610 */ 116,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  5,  0,  0,  0,
/* 0x3620 */   4,  0,  0,  0,  0,  0,  0,  0,187,  0,  0,  0,  0,  0,  0,  0,
/* 0x3630 */   2,  0,  0,  0,  3,  0,  0,  0,165,  0,  0,  0,  0,  0,  0,  0,
/* 0x3640 */  95,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  5,  0,  0,  0,
/* 0x3650 */   4,  0,  0,  0,  0,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x3660 */   2,  0,  0,  0,  4,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,
/* 0x3670 */  21,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  5,  0,  0,  0,
/* 0x3680 */   4,  0,  0,  0,  0,  0,  0,  0,102,105,108,101, 32,102,111,114,
/* 0x3690 */ 109, 97,116, 32,101,108,102, 54, 52, 45,120, 56, 54, 45, 54, 52,
/* 0x36a0 */  10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32,
/* 0x36b0 */  78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,
/* 0x36c0 */ 122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32,
/* 0x36d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,
/* 0x36e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101,
/* 0x36f0 */  32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,
/* 0x3700 */ 115, 10, 32, 32, 48, 32, 46,116,101,120,116, 32, 32, 32, 32, 32,
/* 0x3710 */  32, 32, 32, 32, 48, 57,102, 52, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3720 */  48, 52, 48, 32, 32, 50, 42, 42, 51, 32, 32, 67, 79, 78, 84, 69,
/* 0x3730 */  78, 84, 83, 10, 32, 32, 49, 32, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x3740 */  88, 32, 32, 32, 32, 32, 48,102, 57, 32, 32, 48, 32, 32, 48, 32,
/* 0x3750 */  32, 48, 97, 51, 52, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78,
/* 0x3760 */  84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 83, 89, 83, 67, 65, 76,
/* 0x3770 */  76, 83, 32, 32, 32, 32, 32, 32, 48,100, 99, 32, 32, 48, 32, 32,
/* 0x3780 */  48, 32, 32, 48, 98, 50,100, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3790 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 69, 88, 80, 95,
/* 0x37a0 */  72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48,101, 57, 32, 32, 48,
/* 0x37b0 */  32, 32, 48, 32, 32, 48, 99, 48, 57, 32, 32, 50, 42, 42, 48, 32,
/* 0x37c0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 78, 82,
/* 0x37d0 */  86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,101, 56, 32,
/* 0x37e0 */  32, 48, 32, 32, 48, 32, 32, 48, 99,102, 50, 32, 32, 50, 42, 42,
/* 0x37f0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32,
/* 0x3800 */  78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x3810 */  98, 32, 32, 48, 32, 32, 48, 32, 32, 48,100,100, 97, 32, 32, 50,
/* 0x3820 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x3830 */  54, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3840 */  48, 99, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48,101, 98, 53, 32,
/* 0x3850 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3860 */  32, 32, 55, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 32, 32,
/* 0x3870 */  32, 32, 48, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48,102, 55, 57,
/* 0x3880 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3890 */  10, 32, 32, 56, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32,
/* 0x38a0 */  32, 32, 32, 48, 54, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48,102,
/* 0x38b0 */  56, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x38c0 */  84, 83, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x38d0 */  48, 32, 32, 32, 32, 48, 57,102, 55, 32, 32, 48, 32, 32, 48, 32,
/* 0x38e0 */  32, 48,102,101, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x38f0 */  84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x3900 */  69, 67, 50, 48, 32, 32, 32, 32, 48, 57,102, 55, 32, 32, 48, 32,
/* 0x3910 */  32, 48, 32, 32, 48, 49, 57,100,102, 32, 32, 50, 42, 42, 48, 32,
/* 0x3920 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32, 76, 90,
/* 0x3930 */  77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 49, 57, 32,
/* 0x3940 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 51,100, 54, 32, 32, 50, 42,
/* 0x3950 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50,
/* 0x3960 */  32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48,
/* 0x3970 */  49, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 51,102, 48, 32,
/* 0x3980 */  32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3990 */  32, 49, 51, 32, 83, 84, 82, 67, 79, 78, 32, 32, 32, 32, 32, 32,
/* 0x39a0 */  32, 32, 48, 53, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 52,
/* 0x39b0 */  48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x39c0 */  84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58,
/* 0x39d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x39e0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 46,116,101,120,116, 32,
/* 0x39f0 */  48, 32, 46,116,101,120,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a00 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3a10 */  32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 83, 89, 83, 67,
/* 0x3a20 */  65, 76, 76, 83, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a30 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88,
/* 0x3a40 */  80, 95, 72, 69, 65, 68, 32, 48, 32, 69, 88, 80, 95, 72, 69, 65,
/* 0x3a50 */  68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a60 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x3a70 */  68, 69, 67, 51, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3a80 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a90 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95,
/* 0x3aa0 */  84, 65, 73, 76, 32, 48, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10,
/* 0x3ab0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ac0 */  32,108, 32, 32, 32, 32,100, 32, 32, 83, 84, 82, 67, 79, 78, 32,
/* 0x3ad0 */  48, 32, 83, 84, 82, 67, 79, 78, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ae0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3af0 */  32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48, 32, 85, 77,
/* 0x3b00 */  70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3b20 */  32, 78, 82, 86, 50, 69, 32, 48, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x3b30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3b40 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32, 48, 32,
/* 0x3b50 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b60 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3b70 */  82, 86, 50, 66, 32, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x3b80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3b90 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89,
/* 0x3ba0 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 10, 48, 48,
/* 0x3bb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3bc0 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x3bd0 */  48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48,
/* 0x3be0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3bf0 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3c00 */  49, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3c10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c20 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3c30 */  67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x3c40 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x3c50 */  97, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x3c60 */  76, 83, 32, 48, 32, 80,109, 97,112, 10, 48, 48, 48, 48, 48, 48,
/* 0x3c70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32,
/* 0x3c80 */  32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48, 32,102, 95,
/* 0x3c90 */ 101,120,112, 97,110,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ca0 */  48, 48, 48, 48, 49, 54, 51, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3cb0 */  46,116,101,120,116, 32, 48, 32,103,101,116, 95,112, 97,103,101,
/* 0x3cc0 */  95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3cd0 */  48, 48, 48, 48, 98, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3ce0 */  89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,117,110,109, 97,112,
/* 0x3cf0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x3d00 */  52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65,
/* 0x3d10 */  73, 76, 32, 48, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x3d20 */ 100, 95,102,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d30 */  48, 48, 51, 50, 52, 32,103, 32, 32, 32, 32, 32, 70, 32, 46,116,
/* 0x3d40 */ 101,120,116, 32, 48, 49, 50, 98, 32,120,102,105,110,100, 95,112,
/* 0x3d50 */  97,103,101,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d60 */  48, 48, 48, 55, 54, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x3d70 */  83, 67, 65, 76, 76, 83, 32, 48, 32, 80,115,121,110, 99, 10, 48,
/* 0x3d80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 52, 32,
/* 0x3d90 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83,
/* 0x3da0 */  32, 48, 32,102,116,114,117,110, 99, 97,116,101, 10, 48, 48, 48,
/* 0x3db0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 98, 32,103, 32,
/* 0x3dc0 */  32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48,
/* 0x3dd0 */  32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3de0 */  48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 85,
/* 0x3df0 */  77, 70, 95, 76, 73, 78, 85, 88, 32, 48,102, 57, 32,117,112,120,
/* 0x3e00 */  95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,
/* 0x3e10 */ 117,120, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e20 */  48,100, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67,
/* 0x3e30 */  65, 76, 76, 83, 32, 48, 32,119,114,105,116,101, 10, 48, 48, 48,
/* 0x3e40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 99, 53, 32,103, 32,
/* 0x3e50 */  32, 32, 32, 32, 70, 32, 46,116,101,120,116, 32, 48, 49, 50,102,
/* 0x3e60 */  32,117,112,120, 95,109, 97,105,110, 50, 10, 48, 48, 48, 48, 48,
/* 0x3e70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x3e80 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,109,101,109,102,
/* 0x3e90 */ 100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ea0 */  48, 48, 48, 48, 48, 48, 48,100, 56, 32,103, 32, 32, 32, 32, 32,
/* 0x3eb0 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,114,101, 97,
/* 0x3ec0 */ 100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x3ed0 */ 100, 57, 32,103, 32, 32, 32, 32, 32, 70, 32, 46,116,101,120,116,
/* 0x3ee0 */  32, 48, 52, 98, 32,117,110,100,101,114,108, 97,121, 10, 48, 48,
/* 0x3ef0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100, 48, 32,103,
/* 0x3f00 */  32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32,
/* 0x3f10 */  48, 32,109,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f20 */  48, 48, 48, 48, 48, 48, 49, 49, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x3f30 */  32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,117,112,120,102,
/* 0x3f40 */ 100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x3f60 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,121, 95,
/* 0x3f70 */  98,107,112,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f80 */  48, 48, 48, 56,102, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x3f90 */  83, 67, 65, 76, 76, 83, 32, 48, 32, 80,112,114,111,116,101, 99,
/* 0x3fa0 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3fb0 */ 100, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65,
/* 0x3fc0 */  76, 76, 83, 32, 48, 32, 80,119,114,105,116,101, 10, 48, 48, 48,
/* 0x3fd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 52, 32,103, 32,
/* 0x3fe0 */  32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48,
/* 0x3ff0 */  32, 80,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4000 */  48, 48, 48, 48, 48, 48, 98, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x4010 */  32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,101,120,105,116,
/* 0x4020 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98,
/* 0x4030 */  99, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x4040 */  76, 83, 32, 48, 32, 98,114,107, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4050 */  48, 48, 48, 48, 48, 48, 48, 99, 56, 32,103, 32, 32, 32, 32, 32,
/* 0x4060 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,111,112,101,
/* 0x4070 */ 110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4080 */  99, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65,
/* 0x4090 */  76, 76, 83, 32, 48, 32,109,112,114,111,116,101, 99,116, 10, 48,
/* 0x40a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 48, 32,
/* 0x40b0 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83,
/* 0x40c0 */  32, 48, 32, 99,108,111,115,101, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x40d0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x40e0 */  32, 91, 46,116,101,120,116, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x40f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4100 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4110 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4120 */  48, 56, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51,
/* 0x4130 */  50, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 43, 48,
/* 0x4140 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4150 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4160 */  56, 55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,
/* 0x4170 */  32, 32, 32, 32, 32,111,112,101,110, 43, 48,120,102,102,102,102,
/* 0x4180 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4190 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 48, 32, 82, 95,
/* 0x41a0 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x41b0 */ 117,112,120, 95,109, 97,105,110, 50, 43, 48,120,102,102,102,102,
/* 0x41c0 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x41d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 51, 51, 32, 82, 95,
/* 0x41e0 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x41f0 */ 109,117,110,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4200 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4210 */  48, 48, 48, 48, 48, 48, 48, 49, 52,102, 32, 82, 95, 88, 56, 54,
/* 0x4220 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,109,109, 97,
/* 0x4230 */ 112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4240 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4250 */  48, 48, 49, 53, 54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4260 */  67, 51, 50, 32, 32, 32, 32, 32, 99,108,111,115,101, 43, 48,120,
/* 0x4270 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4280 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 56,
/* 0x4290 */  48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x42a0 */  32, 32, 32, 32,101,120,105,116, 43, 48,120,102,102,102,102,102,
/* 0x42b0 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x42c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49,102, 54, 32, 82, 95, 88,
/* 0x42d0 */  56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,101,
/* 0x42e0 */ 120,105,116, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x42f0 */ 102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4300 */  48, 48, 48, 48, 50, 50, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4310 */  95, 80, 76, 84, 51, 50, 32, 32, 32, 32,102, 95,101,120,112, 97,
/* 0x4320 */ 110,100, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4330 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4340 */  48, 48, 48, 50, 99,100, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4350 */  80, 76, 84, 51, 50, 32, 32, 32, 32,101,120,105,116, 43, 48,120,
/* 0x4360 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4370 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 48,
/* 0x4380 */  57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x4390 */  32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,102,102,102,102,
/* 0x43a0 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x43b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 53, 48, 32, 82, 95, 88,
/* 0x43c0 */  56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,103,
/* 0x43d0 */ 101,116, 95,112, 97,103,101, 95,109, 97,115,107, 43, 48,120,102,
/* 0x43e0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x43f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51,101,100,
/* 0x4400 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32,
/* 0x4410 */  32, 32, 32,109,109, 97,112, 43, 48,120,102,102,102,102,102,102,
/* 0x4420 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x4430 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 49, 56, 32, 82, 95, 88, 56,
/* 0x4440 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,117,
/* 0x4450 */ 110,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4460 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4470 */  48, 48, 48, 48, 48, 52, 50, 57, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4480 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,117,110,109, 97,
/* 0x4490 */ 112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x44a0 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44b0 */  48, 48, 52,100, 57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x44c0 */  76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,
/* 0x44d0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x44e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 48, 50,
/* 0x44f0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32,
/* 0x4500 */  32, 32, 32,120,102,105,110,100, 95,112, 97,103,101,115, 43, 48,
/* 0x4510 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4520 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x4530 */  48, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4540 */  50, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,
/* 0x4550 */ 115,107, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4560 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4570 */  48, 48, 48, 54, 52, 57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4580 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 83, 84, 82, 67, 79, 78, 43,
/* 0x4590 */  48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45a0 */  52, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45b0 */  54, 52,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x45c0 */  51, 50, 32, 32, 32, 32,117,112,120,102,100, 95, 99,114,101, 97,
/* 0x45d0 */ 116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x45e0 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45f0 */  48, 48, 48, 54, 53, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4600 */  80, 76, 84, 51, 50, 32, 32, 32, 32,102,116,114,117,110, 99, 97,
/* 0x4610 */ 116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4620 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4630 */  48, 48, 48, 54, 57, 57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4640 */  80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,120,
/* 0x4650 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4660 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 99,
/* 0x4670 */  51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x4680 */  32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,102,102,102,102,
/* 0x4690 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x46a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 57, 50, 32, 82, 95, 88,
/* 0x46b0 */  56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 83,
/* 0x46c0 */  84, 82, 67, 79, 78, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x46d0 */  48, 48, 48, 48, 48, 48, 52, 98, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x46e0 */  48, 48, 48, 48, 48, 48, 55, 57, 55, 32, 82, 95, 88, 56, 54, 95,
/* 0x46f0 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,117,112,120,102,
/* 0x4700 */ 100, 95, 99,114,101, 97,116,101, 43, 48,120,102,102,102,102,102,
/* 0x4710 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x4720 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 97, 97, 32, 82, 95, 88,
/* 0x4730 */  56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,119,
/* 0x4740 */ 114,105,116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4750 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4760 */  48, 48, 48, 48, 48, 55, 99, 54, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4770 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43,
/* 0x4780 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4790 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x47a0 */  55,100, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x47b0 */  51, 50, 32, 32, 32, 32, 99,108,111,115,101, 43, 48,120,102,102,
/* 0x47c0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48,
/* 0x47d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,102, 55, 32,
/* 0x47e0 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32,
/* 0x47f0 */  32, 32, 80,115,121,110, 99, 43, 48,120,102,102,102,102,102,102,
/* 0x4800 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x4810 */  48, 48, 48, 48, 48, 48, 48, 48, 56, 48, 50, 32, 82, 95, 88, 56,
/* 0x4820 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,117,
/* 0x4830 */ 110,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4840 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4850 */  48, 48, 48, 48, 48, 56, 49,101, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4860 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43,
/* 0x4870 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4880 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4890 */  56, 50, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x48a0 */  51, 50, 32, 32, 32, 32, 99,108,111,115,101, 43, 48,120,102,102,
/* 0x48b0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48,
/* 0x48c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 52, 52, 32,
/* 0x48d0 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32,
/* 0x48e0 */  32, 32, 80,112,114,111,116,101, 99,116, 43, 48,120,102,102,102,
/* 0x48f0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4900 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 53, 50, 32, 82,
/* 0x4910 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x4920 */  32,101,120,105,116, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4930 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4940 */  48, 48, 48, 48, 48, 48, 56, 55, 98, 32, 82, 95, 88, 56, 54, 95,
/* 0x4950 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112,
/* 0x4960 */  43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4970 */ 102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4980 */  48, 56, 97,100, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76,
/* 0x4990 */  84, 51, 50, 32, 32, 32, 32, 98,114,107, 43, 48,120,102,102,102,
/* 0x49a0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x49b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 50, 56, 32, 82,
/* 0x49c0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x49d0 */  32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 43, 48,
/* 0x49e0 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x49f0 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57,
/* 0x4a00 */  55, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4a10 */  50, 32, 32, 32, 32,111,112,101,110, 43, 48,120,102,102,102,102,
/* 0x4a20 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4a30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 57, 48, 32, 82, 95,
/* 0x4a40 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x4a50 */ 114,101, 97,100, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4a60 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a70 */  48, 48, 48, 48, 48, 57, 97, 50, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4a80 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,101,120,105,116, 43,
/* 0x4a90 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4aa0 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ab0 */  57,100, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x4ac0 */  51, 50, 32, 32, 32, 32, 99,108,111,115,101, 43, 48,120,102,102,
/* 0x4ad0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 10,
/* 0x4ae0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4af0 */  68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x4b00 */  88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x4b10 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4b20 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4b30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95,
/* 0x4b40 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4b50 */  83, 84, 82, 67, 79, 78, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4b60 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4b70 */  48, 48, 48, 48, 48, 48, 48, 48, 50,101, 32, 82, 95, 88, 56, 54,
/* 0x4b80 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,101,109,
/* 0x4b90 */ 102,100, 95, 99,114,101, 97,116,101, 43, 48,120,102,102,102,102,
/* 0x4ba0 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4bb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 50, 32, 82, 95,
/* 0x4bc0 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x4bd0 */ 109,101,109,102,100, 95, 99,114,101, 97,116,101, 43, 48,120,102,
/* 0x4be0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x4bf0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,102,
/* 0x4c00 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32,
/* 0x4c10 */  32, 32, 32, 83, 84, 82, 67, 79, 78, 10, 48, 48, 48, 48, 48, 48,
/* 0x4c20 */  48, 48, 48, 48, 48, 48, 48, 48, 53,101, 32, 82, 95, 88, 56, 54,
/* 0x4c30 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,111,112,101,
/* 0x4c40 */ 110, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4c50 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c60 */  48, 48, 48, 55, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4c70 */  67, 51, 50, 32, 32, 32, 32, 32, 83, 84, 82, 67, 79, 78, 43, 48,
/* 0x4c80 */ 120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c90 */  57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ca0 */  56, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4cb0 */  50, 32, 32, 32, 32,119,114,105,116,101, 43, 48,120,102,102,102,
/* 0x4cc0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4cd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82,
/* 0x4ce0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x4cf0 */  32,101,120,105,116, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4d00 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d10 */  48, 48, 48, 48, 48, 48, 48, 57, 54, 32, 82, 95, 88, 56, 54, 95,
/* 0x4d20 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,102,116,114,117,
/* 0x4d30 */ 110, 99, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4d40 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d50 */  48, 48, 48, 48, 48, 48, 48, 99, 50, 32, 82, 95, 88, 56, 54, 95,
/* 0x4d60 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112,
/* 0x4d70 */  43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4d80 */ 102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d90 */  48, 48, 99, 97, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76,
/* 0x4da0 */  84, 51, 50, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,
/* 0x4db0 */ 109, 97,115,107, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4dc0 */ 102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4dd0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4de0 */  91, 83, 89, 83, 67, 65, 76, 76, 83, 93, 58, 10, 79, 70, 70, 83,
/* 0x4df0 */  69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80,
/* 0x4e00 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4e10 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e20 */  48, 48, 48, 52,100, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4e30 */  67, 51, 50, 32, 32, 32, 32, 32, 46,116,101,120,116, 43, 48,120,
/* 0x4e40 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4e50 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x4e60 */  56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x4e70 */  32, 32, 32, 32, 46,116,101,120,116, 43, 48,120,102,102,102,102,
/* 0x4e80 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4e90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 49, 32, 82, 95,
/* 0x4ea0 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4eb0 */  46,116,101,120,116, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4ec0 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ed0 */  48, 48, 48, 48, 48, 48, 48, 97, 54, 32, 82, 95, 88, 56, 54, 95,
/* 0x4ee0 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 46,116,101,120,
/* 0x4ef0 */ 116, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4f00 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f10 */  48, 48, 48, 56, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4f20 */  67, 51, 50, 32, 32, 32, 32, 32,109,115,121,110, 99, 43, 48,120,
/* 0x4f30 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4f40 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97,
/* 0x4f50 */  48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x4f60 */  32, 32, 32, 32,109,112,114,111,116,101, 99,116, 43, 48,120,102,
/* 0x4f70 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x4f80 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4f90 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58,
/* 0x4fa0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fb0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fc0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4fd0 */  48, 48, 48, 48, 48, 48, 48, 48,100,102, 32, 82, 95, 88, 56, 54,
/* 0x4fe0 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80,
/* 0x4ff0 */  95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5000 */  48, 48, 48, 48, 48, 48, 97, 53, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5010 */  48, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 88, 56, 54, 95,
/* 0x5020 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95,
/* 0x5030 */  84, 65, 73, 76, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5040 */  48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5050 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5060 */  91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5070 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5080 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5090 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x50a0 */ 100, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,
/* 0x50b0 */  32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 43, 48,120,
/* 0x50c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 53,
/* 0x50d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x50e0 */  52, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x50f0 */  32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48,
/* 0x5100 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10,
/* 0x5110 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5120 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58,
/* 0x5130 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5140 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5150 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5160 */  48, 48, 48, 48, 48, 48, 48, 48, 98, 98, 32, 82, 95, 88, 56, 54,
/* 0x5170 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80,
/* 0x5180 */  95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5190 */  48, 48, 48, 48, 48, 48, 97, 53, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x51a0 */  48, 48, 48, 48, 48, 48, 48, 53,102, 32, 82, 95, 88, 56, 54, 95,
/* 0x51b0 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95,
/* 0x51c0 */  84, 65, 73, 76, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x51d0 */  48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x51e0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x51f0 */  91, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 93, 58, 10, 79, 70,
/* 0x5200 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x5210 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5220 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5230 */  48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x5240 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x5250 */  69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5260 */  48, 48, 48, 48, 48, 49, 53, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5270 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5280 */  91, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70,
/* 0x5290 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x52a0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x52b0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x52c0 */  48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x52d0 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65,
/* 0x52e0 */  73, 76, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x52f0 */  48, 48, 48, 48, 52, 10
};
